/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;

public class JDOHelperGetVersionMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression ignore, List<SQLExpression> args) {
        if (args == null || args.size() == 0) {
            throw new NucleusUserException("Cannot invoke JDOHelper.getVersion without an argument");
        }
        SQLExpression expr = args.get(0);
        if (expr == null) {
            throw new NucleusUserException("Cannot invoke JDOHelper.getVersion on null expression");
        }
        if (expr instanceof SQLLiteral) {
            RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
            ApiAdapter api = storeMgr.getApiAdapter();
            Object obj = ((SQLLiteral)((Object)expr)).getValue();
            if (obj == null || !api.isPersistable(obj)) {
                return new NullLiteral(stmt, null, null, null);
            }
            Object ver = stmt.getRDBMSManager().getApiAdapter().getVersionForObject(obj);
            JavaTypeMapping m = stmt.getSQLExpressionFactory().getMappingForType(ver.getClass(), true);
            return new ObjectLiteral(stmt, m, ver, null);
        }
        if (ObjectExpression.class.isAssignableFrom(expr.getClass())) {
            if (((ObjectExpression)expr).getJavaTypeMapping() instanceof PersistableMapping) {
                JavaTypeMapping mapping = ((ObjectExpression)expr).getJavaTypeMapping();
                DatastoreClass table = (DatastoreClass)expr.getSQLTable().getTable();
                if (table.getIdMapping() == mapping) {
                    mapping = table.getSurrogateMapping(SurrogateColumnType.VERSION, true);
                    if (mapping == null) {
                        throw new NucleusUserException("Cannot use JDOHelper.getVersion on object that has no version information");
                    }
                    if (table.getVersionMetaData().getStrategy() == VersionStrategy.VERSION_NUMBER) {
                        return new NumericExpression(stmt, expr.getSQLTable(), mapping);
                    }
                    return new TemporalExpression(stmt, expr.getSQLTable(), mapping);
                }
                throw new NucleusUserException("Dont currently support JDOHelper.getVersion(ObjectExpression) for expr=" + expr + " on table=" + expr.getSQLTable());
            }
            return expr;
        }
        throw new IllegalExpressionOperationException("JDOHelper.getVersion", expr);
    }
}

