/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BinaryLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.DelegatedExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.types.converters.TypeConverter;

public class TypeConverterLiteral
extends DelegatedExpression
implements SQLLiteral {
    public TypeConverterLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        if (!(mapping instanceof TypeConverterMapping)) {
            throw new NucleusException("Attempt to create TypeConverterLiteral for mapping of type " + mapping.getClass().getName());
        }
        TypeConverterMapping convMapping = (TypeConverterMapping)mapping;
        TypeConverter conv = convMapping.getTypeConverter();
        Class datastoreType = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getDatastoreTypeForTypeConverter(conv, convMapping.getJavaType());
        value = conv.toDatastoreType(value);
        if (datastoreType == String.class) {
            this.delegate = new StringLiteral(stmt, mapping, value, parameterName);
        } else if (Date.class.isAssignableFrom(datastoreType)) {
            this.delegate = new TemporalLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Integer.class || datastoreType == Long.class || datastoreType == Short.class || datastoreType == BigInteger.class) {
            this.delegate = new IntegerLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Double.class || datastoreType == Float.class || datastoreType == BigDecimal.class) {
            this.delegate = new FloatingPointLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Boolean.class) {
            this.delegate = new BooleanLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Byte.class) {
            this.delegate = new ByteLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Character.class) {
            this.delegate = new CharacterLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Enum.class) {
            this.delegate = new EnumLiteral(stmt, mapping, value, parameterName);
        } else if (datastoreType == Byte[].class || datastoreType == byte[].class) {
            this.delegate = new BinaryLiteral(stmt, mapping, value, parameterName);
        } else {
            throw new NucleusException("Could not create TypeConverterLiteral for mapping of type " + mapping.getClass().getName() + " with datastoreType=" + datastoreType.getName() + " - no available supported expression");
        }
    }

    @Override
    public Object getValue() {
        return ((SQLLiteral)((Object)this.delegate)).getValue();
    }

    @Override
    public void setNotParameter() {
        ((SQLLiteral)((Object)this.delegate)).setNotParameter();
    }
}

