/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.NullOrderingType;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLColumn;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.AggregateExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ResultAliasExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SelectStatement
extends SQLStatement {
    protected boolean allowUnions = true;
    protected List<SelectStatement> unions = null;
    protected boolean distinct = false;
    protected List<SelectedItem> selectedItems = new ArrayList<SelectedItem>();
    protected boolean aggregated = false;
    protected List<SQLExpression> groupingExpressions = null;
    protected BooleanExpression having;
    protected SQLExpression[] orderingExpressions = null;
    protected boolean[] orderingDirections = null;
    protected NullOrderingType[] orderNullDirectives = null;
    protected long rangeOffset = -1L;
    protected long rangeCount = -1L;
    private int[] orderingColumnIndexes;

    public SelectStatement(RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName) {
        super(null, rdbmsMgr, table, alias, tableGroupName, null);
    }

    public SelectStatement(RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName, Map<String, Object> extensions) {
        super(null, rdbmsMgr, table, alias, tableGroupName, extensions);
    }

    public SelectStatement(SQLStatement parentStmt, RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName) {
        super(parentStmt, rdbmsMgr, table, alias, tableGroupName, null);
    }

    public SelectStatement(SQLStatement parentStmt, RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName, Map<String, Object> extensions) {
        super(parentStmt, rdbmsMgr, table, alias, tableGroupName, extensions);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.invalidateStatement();
        this.distinct = distinct;
    }

    public int getNumberOfSelects() {
        return this.selectedItems.size();
    }

    public int[] select(SQLExpression expr, String alias) {
        if (expr == null) {
            throw new NucleusException("Expression to select is null");
        }
        this.invalidateStatement();
        boolean primary = true;
        if (expr instanceof AggregateExpression) {
            this.aggregated = true;
            primary = false;
        } else if (expr.getSQLTable() == null || expr.getJavaTypeMapping() == null) {
            primary = false;
        }
        int[] selected = new int[expr.getNumberOfSubExpressions()];
        if (expr.getNumberOfSubExpressions() > 1) {
            for (int i = 0; i < expr.getNumberOfSubExpressions(); ++i) {
                selected[i] = this.selectItem(expr.getSubExpression(i).toSQLText(), alias != null ? alias + i : null, primary);
            }
        } else {
            selected[0] = this.selectItem(expr.toSQLText(), alias, primary);
        }
        if (this.unions != null && this.allowUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.select(expr, alias);
            }
        }
        return selected;
    }

    public int[] select(SQLTable table, JavaTypeMapping mapping, String alias, boolean applyToUnions) {
        if (mapping == null) {
            throw new NucleusException("Mapping to select is null");
        }
        if (table == null) {
            table = this.primaryTable;
        }
        if (mapping.getTable() != table.getTable()) {
            throw new NucleusException("Table being selected from (\"" + table.getTable() + "\") is inconsistent with the column selected (\"" + mapping.getTable() + "\")");
        }
        this.invalidateStatement();
        ColumnMapping[] mappings = mapping.getColumnMappings();
        int[] selected = new int[mappings.length];
        for (int i = 0; i < selected.length; ++i) {
            DatastoreIdentifier colAlias = null;
            if (alias != null) {
                String name = selected.length > 1 ? alias + "_" + i : alias;
                colAlias = this.rdbmsMgr.getIdentifierFactory().newColumnIdentifier(name);
            }
            SQLColumn col = new SQLColumn(table, mappings[i].getColumn(), colAlias);
            selected[i] = this.selectItem(new SQLText(col.getColumnSelectString()), alias != null ? colAlias.toString() : null, true);
        }
        if (applyToUnions && this.unions != null && this.allowUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.select(table, mapping, alias);
            }
        }
        return selected;
    }

    public int[] select(SQLTable table, JavaTypeMapping mapping, String alias) {
        return this.select(table, mapping, alias, true);
    }

    public int select(SQLTable table, Column column, String alias) {
        if (column == null) {
            throw new NucleusException("Column to select is null");
        }
        if (table == null) {
            table = this.primaryTable;
        }
        if (column.getTable() != table.getTable()) {
            throw new NucleusException("Table being selected from (\"" + table.getTable() + "\") is inconsistent with the column selected (\"" + column.getTable() + "\")");
        }
        this.invalidateStatement();
        DatastoreIdentifier colAlias = null;
        if (alias != null) {
            colAlias = this.rdbmsMgr.getIdentifierFactory().newColumnIdentifier(alias);
        }
        SQLColumn col = new SQLColumn(table, column, colAlias);
        int position = this.selectItem(new SQLText(col.getColumnSelectString()), alias != null ? colAlias.toString() : null, true);
        if (this.unions != null && this.allowUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.select(table, column, alias);
            }
        }
        return position;
    }

    protected int selectItem(SQLText st, String alias, boolean primary) {
        SelectedItem item = new SelectedItem(st, alias, primary);
        if (this.selectedItems.contains(item)) {
            return this.selectedItems.indexOf(item) + 1;
        }
        for (SelectedItem currentItem : this.selectedItems) {
            if (!currentItem.getSQLText().toSQL().equals(st.toSQL()) || currentItem.getAlias() != null || alias == null || currentItem.isPrimary() != primary) continue;
            currentItem.setAlias(alias);
            return this.selectedItems.indexOf(currentItem) + 1;
        }
        int numberSelected = this.selectedItems.size();
        for (int i = 0; i < numberSelected; ++i) {
            SelectedItem selectedItem = this.selectedItems.get(i);
            if (!selectedItem.getSQLText().equals(st)) continue;
            return i + 1;
        }
        this.selectedItems.add(item);
        return this.selectedItems.indexOf(item) + 1;
    }

    @Override
    public void addAndConditionToJoinForTable(SQLTable sqlTbl, BooleanExpression andCondition, boolean applyToUnions) {
        SQLJoin join = this.getJoinForTable(sqlTbl);
        if (join != null) {
            join.addAndCondition(andCondition);
        }
        if (this.unions != null && applyToUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.addAndConditionToJoinForTable(sqlTbl, andCondition, applyToUnions);
            }
        }
    }

    public void addGroupingExpression(SQLExpression expr) {
        this.invalidateStatement();
        if (this.groupingExpressions == null) {
            this.groupingExpressions = new ArrayList<SQLExpression>();
        }
        this.groupingExpressions.add(expr);
        this.aggregated = true;
        if (this.unions != null && this.allowUnions) {
            Iterator<SelectStatement> i = this.unions.iterator();
            while (i.hasNext()) {
                i.next().addGroupingExpression(expr);
            }
        }
    }

    public void setHaving(BooleanExpression expr) {
        this.invalidateStatement();
        this.having = expr;
        this.aggregated = true;
        if (this.unions != null && this.allowUnions) {
            Iterator<SelectStatement> i = this.unions.iterator();
            while (i.hasNext()) {
                i.next().setHaving(expr);
            }
        }
    }

    public void setOrdering(SQLExpression[] exprs, boolean[] descending) {
        this.setOrdering(exprs, descending, null);
    }

    public void setOrdering(SQLExpression[] exprs, boolean[] descending, NullOrderingType[] nullOrders) {
        if (exprs != null && descending != null && exprs.length != descending.length) {
            throw new NucleusException(Localiser.msg((String)"052503", (Object[])new Object[]{"" + exprs.length, "" + descending.length})).setFatal();
        }
        this.invalidateStatement();
        this.orderingExpressions = exprs;
        this.orderingDirections = descending;
        this.orderNullDirectives = nullOrders;
    }

    public void setRange(long offset, long count) {
        this.invalidateStatement();
        this.rangeOffset = offset;
        this.rangeCount = count;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SQLText getSQLText() {
        String limitClause;
        SQLText orderStmt;
        if (this.sql != null) {
            return this.sql;
        }
        DatastoreAdapter dba = this.getDatastoreAdapter();
        boolean lock = false;
        Boolean val = (Boolean)this.getValueForExtension("lock-for-update");
        if (val != null) {
            lock = val;
        }
        boolean addAliasToAllSelects = false;
        if ((this.rangeOffset > 0L || this.rangeCount > -1L) && dba.getRangeByRowNumberColumn2().length() > 0) {
            addAliasToAllSelects = true;
        }
        this.sql = new SQLText("SELECT ");
        if (this.distinct) {
            this.sql.append("DISTINCT ");
        }
        this.addOrderingColumnsToSelect();
        if (this.selectedItems.isEmpty()) {
            this.sql.append("*");
        } else {
            int autoAliasNum = 0;
            Iterator<SelectedItem> selectItemIter = this.selectedItems.iterator();
            while (selectItemIter.hasNext()) {
                SelectedItem selectedItem = selectItemIter.next();
                SQLText selectedST = selectedItem.getSQLText();
                this.sql.append(selectedST);
                if (selectedItem.getAlias() != null) {
                    this.sql.append(" AS " + this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase(selectedItem.getAlias()));
                } else if (addAliasToAllSelects) {
                    this.sql.append(" AS ").append(this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase("DN_" + autoAliasNum));
                    ++autoAliasNum;
                }
                if (!selectItemIter.hasNext()) continue;
                this.sql.append(',');
            }
            if ((this.rangeOffset > -1L || this.rangeCount > -1L) && dba.getRangeByRowNumberColumn().length() > 0) {
                this.sql.append(',').append(dba.getRangeByRowNumberColumn()).append(" rn");
            }
        }
        this.sql.append(" FROM ");
        this.sql.append(this.primaryTable.toString());
        if (lock && dba.supportsOption("LockRowUsingOptionAfterFrom")) {
            this.sql.append(" WITH ").append(dba.getSelectWithLockOption());
        }
        if (this.joins != null) {
            this.sql.append(this.getSqlForJoins(lock));
        }
        if (this.where != null) {
            this.sql.append(" WHERE ").append(this.where.toSQLText());
        }
        if (this.groupingExpressions != null) {
            ArrayList<SQLText> groupBy = new ArrayList<SQLText>();
            for (SQLExpression sQLExpression : this.groupingExpressions) {
                boolean exists = false;
                String exprSQL = sQLExpression.toSQLText().toSQL();
                for (SQLText st : groupBy) {
                    String sql = st.toSQL();
                    if (!sql.equals(exprSQL)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                groupBy.add(sQLExpression.toSQLText());
            }
            if (dba.supportsOption("GroupByIncludesAllSelectPrimaries")) {
                for (SelectedItem selItem : this.selectedItems) {
                    if (!selItem.isPrimary()) continue;
                    boolean exists = false;
                    String selItemSQL = selItem.getSQLText().toSQL();
                    for (SQLText st : groupBy) {
                        String sql = st.toSQL();
                        if (!sql.equals(selItemSQL)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    groupBy.add(selItem.getSQLText());
                }
            }
            if (groupBy.size() > 0 && this.aggregated) {
                void var7_16;
                this.sql.append(" GROUP BY ");
                boolean bl = false;
                while (var7_16 < groupBy.size()) {
                    if (var7_16 > 0) {
                        this.sql.append(',');
                    }
                    this.sql.append((SQLText)groupBy.get((int)var7_16));
                    ++var7_16;
                }
            }
        }
        if (this.having != null) {
            this.sql.append(" HAVING ").append(this.having.toSQLText());
        }
        if (this.unions != null && this.allowUnions) {
            if (!dba.supportsOption("Union_Syntax")) {
                throw new NucleusException(Localiser.msg((String)"052504", (Object[])new Object[]{"UNION"})).setFatal();
            }
            Iterator<SelectStatement> unionIter = this.unions.iterator();
            while (unionIter.hasNext()) {
                if (dba.supportsOption("UseUnionAll")) {
                    this.sql.append(" UNION ALL ");
                } else {
                    this.sql.append(" UNION ");
                }
                SelectStatement stmt = unionIter.next();
                SQLText sQLText = stmt.getSQLText();
                this.sql.append(sQLText);
            }
        }
        if ((orderStmt = this.generateOrderingStatement()) != null) {
            this.sql.append(" ORDER BY ").append(orderStmt);
        }
        if ((this.rangeOffset > -1L || this.rangeCount > -1L) && (limitClause = dba.getRangeByLimitEndOfStatementClause(this.rangeOffset, this.rangeCount, orderStmt != null)).length() > 0) {
            this.sql.append(" ").append(limitClause);
        }
        if (lock) {
            if (dba.supportsOption("LockRowUsingSelectForUpdate")) {
                if (this.distinct && !dba.supportsOption("DistinctWithSelectForUpdate")) {
                    NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052502"));
                } else if (this.groupingExpressions != null && !dba.supportsOption("GroupingWithSelectForUpdate")) {
                    NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052506"));
                } else if (this.having != null && !dba.supportsOption("HavingWithSelectForUpdate")) {
                    NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052507"));
                } else if (this.orderingExpressions != null && !dba.supportsOption("OrderingWithSelectForUpdate")) {
                    NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052508"));
                } else if (this.joins != null && !this.joins.isEmpty() && !dba.supportsOption("MultipleTablesWithSelectForUpdate")) {
                    NucleusLogger.QUERY.warn((Object)Localiser.msg((String)"052509"));
                } else {
                    Boolean nowait;
                    this.sql.append(" " + dba.getSelectForUpdateText());
                    if (dba.supportsOption("LockRowSelectForUpdateNowait") && (nowait = (Boolean)this.getValueForExtension("for-update-nowait")) != null) {
                        this.sql.append(" NOWAIT");
                    }
                }
            } else if (!dba.supportsOption("LockRowUsingOptionAfterFrom") && !dba.supportsOption("LockRowUsingOptionWithinJoin")) {
                NucleusLogger.QUERY.warn((Object)"Requested locking of query statement, but this RDBMS doesn't support a convenient mechanism");
            }
        }
        if (this.rangeOffset > 0L || this.rangeCount > -1L) {
            SQLText userSql;
            if (dba.getRangeByRowNumberColumn2().length() > 0) {
                userSql = this.sql;
                SQLText sQLText = new SQLText("SELECT subq.*");
                sQLText.append(',').append(dba.getRangeByRowNumberColumn2()).append(" rn");
                sQLText.append(" FROM (").append(userSql).append(") subq ");
                SQLText outerSql = new SQLText("SELECT * FROM (").append(sQLText).append(") ");
                outerSql.append("WHERE ");
                if (this.rangeOffset > 0L) {
                    outerSql.append("rn > " + this.rangeOffset);
                    if (this.rangeCount > -1L) {
                        outerSql.append(" AND rn <= " + (this.rangeCount + this.rangeOffset));
                    }
                } else {
                    outerSql.append(" rn <= " + this.rangeCount);
                }
                this.sql = outerSql;
            } else if (dba.getRangeByRowNumberColumn().length() > 0) {
                userSql = this.sql;
                this.sql = new SQLText("SELECT ");
                Iterator<SelectedItem> iterator = this.selectedItems.iterator();
                while (iterator.hasNext()) {
                    SelectedItem selectedItemExpr = iterator.next();
                    this.sql.append("subq.");
                    String selectedCol = selectedItemExpr.getSQLText().toSQL();
                    if (selectedItemExpr.getAlias() != null) {
                        selectedCol = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase(selectedItemExpr.getAlias());
                    } else {
                        int dotIndex = selectedCol.indexOf(".");
                        if (dotIndex > 0) {
                            selectedCol = selectedCol.substring(dotIndex + 1);
                        }
                    }
                    this.sql.append(selectedCol);
                    if (!iterator.hasNext()) continue;
                    this.sql.append(',');
                }
                this.sql.append(" FROM (").append(userSql).append(") subq WHERE ");
                if (this.rangeOffset > 0L) {
                    this.sql.append("subq.rn").append(">").append("" + this.rangeOffset);
                }
                if (this.rangeCount > 0L) {
                    if (this.rangeOffset > 0L) {
                        this.sql.append(" AND ");
                    }
                    this.sql.append("subq.rn").append("<=").append("" + (this.rangeCount + this.rangeOffset));
                }
            }
        }
        return this.sql;
    }

    private List<SQLJoin> reorderJoins(List<SQLJoin> joinsToAdd) {
        ArrayList<SQLJoin> orderedJoins = new ArrayList<SQLJoin>();
        if (joinsToAdd == null) {
            this.requiresJoinReorder = false;
            return orderedJoins;
        }
        while (joinsToAdd.size() > 0) {
            Iterator<SQLJoin> joinIter = joinsToAdd.iterator();
            int origSize = joinsToAdd.size();
            while (joinIter.hasNext()) {
                SQLJoin join = joinIter.next();
                if (join.getType() == SQLJoin.JoinType.CROSS_JOIN) {
                    orderedJoins.add(join);
                    joinIter.remove();
                    continue;
                }
                if (join.getType() == SQLJoin.JoinType.NON_ANSI_JOIN) {
                    orderedJoins.add(join);
                    joinIter.remove();
                    continue;
                }
                if (join.getSourceTable().equals(this.primaryTable)) {
                    orderedJoins.add(join);
                    joinIter.remove();
                    continue;
                }
                Iterator knownJoinIter = orderedJoins.iterator();
                boolean valid = false;
                while (knownJoinIter.hasNext()) {
                    SQLJoin currentJoin = (SQLJoin)knownJoinIter.next();
                    if (!join.getSourceTable().equals(currentJoin.getTargetTable())) continue;
                    valid = true;
                    break;
                }
                if (!valid) continue;
                orderedJoins.add(join);
                joinIter.remove();
            }
            if (joinsToAdd.size() != origSize) continue;
            throw new NucleusException("Unable to reorder joins for SQL statement since circular! Consider reordering the components in the WHERE clause : affected joins - " + StringUtils.collectionToString(joinsToAdd));
        }
        this.requiresJoinReorder = false;
        return orderedJoins;
    }

    protected SQLText getSqlForJoins(boolean lock) {
        if (this.requiresJoinReorder) {
            List<SQLJoin> theJoins;
            this.joins = theJoins = this.reorderJoins(this.joins);
        }
        SQLText sql = new SQLText();
        DatastoreAdapter dba = this.getDatastoreAdapter();
        for (SQLJoin join : this.joins) {
            if (join.getType() == SQLJoin.JoinType.CROSS_JOIN) {
                if (dba.supportsOption("ANSI_CrossJoin_Syntax")) {
                    sql.append(" ").append(join.toSQLText(dba, lock));
                    continue;
                }
                if (dba.supportsOption("ANSI_CrossJoinAsInner11_Syntax")) {
                    sql.append(" INNER JOIN " + join.getTargetTable() + " ON 1=1");
                    continue;
                }
                sql.append(",").append(join.getTargetTable().toString());
                continue;
            }
            if (dba.supportsOption("ANSI_Join_Syntax")) {
                sql.append(" ").append(join.toSQLText(dba, lock));
                continue;
            }
            sql.append(",").append(join.toSQLText(dba, lock));
        }
        return sql;
    }

    protected SQLText generateOrderingStatement() {
        SQLText orderStmt;
        block13: {
            orderStmt = null;
            if (this.orderingExpressions == null || this.orderingExpressions.length <= 0) break block13;
            DatastoreAdapter dba = this.getDatastoreAdapter();
            if (dba.supportsOption("OrderByUsingSelectColumnIndex")) {
                orderStmt = new SQLText();
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    if (i > 0) {
                        orderStmt.append(',');
                    }
                    orderStmt.append(Integer.toString(this.orderingColumnIndexes[i]));
                    if (this.orderingDirections[i]) {
                        orderStmt.append(" DESC");
                    }
                    if (this.orderNullDirectives == null || this.orderNullDirectives[i] == null || !dba.supportsOption("OrderByWithNullsDirectives")) continue;
                    orderStmt.append(" " + (this.orderNullDirectives[i] == NullOrderingType.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST"));
                }
            } else {
                orderStmt = new SQLText();
                boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
                if (this.parent != null) {
                    needsSelect = false;
                }
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    String orderStr;
                    NullOrderingType orderNullDirective;
                    SQLExpression orderExpr = this.orderingExpressions[i];
                    boolean orderDirection = this.orderingDirections[i];
                    NullOrderingType nullOrderingType = orderNullDirective = this.orderNullDirectives != null ? this.orderNullDirectives[i] : null;
                    if (i > 0) {
                        orderStmt.append(',');
                    }
                    if (needsSelect && !this.aggregated) {
                        if (orderExpr instanceof ResultAliasExpression) {
                            orderStr = ((ResultAliasExpression)orderExpr).getResultAlias();
                            orderStr = this.rdbmsMgr.getIdentifierFactory().getIdentifierTruncatedToAdapterColumnLength(orderStr);
                            orderStr = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase(orderStr);
                            this.addOrderComponent(orderStmt, orderStr, orderExpr, orderDirection, orderNullDirective, dba);
                            continue;
                        }
                        String orderString = "NUCORDER" + i;
                        if (orderExpr.getNumberOfSubExpressions() == 1) {
                            String orderStr2 = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase(orderString);
                            this.addOrderComponent(orderStmt, orderStr2, orderExpr, orderDirection, orderNullDirective, dba);
                            continue;
                        }
                        ColumnMapping[] mappings = orderExpr.getJavaTypeMapping().getColumnMappings();
                        for (int j = 0; j < mappings.length; ++j) {
                            String orderStr3 = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase(orderString + "_" + j);
                            this.addOrderComponent(orderStmt, orderStr3, orderExpr, orderDirection, orderNullDirective, dba);
                            if (j >= mappings.length - 1) continue;
                            orderStmt.append(',');
                        }
                        continue;
                    }
                    if (orderExpr instanceof ResultAliasExpression) {
                        orderStr = ((ResultAliasExpression)orderExpr).getResultAlias();
                        orderStr = this.rdbmsMgr.getIdentifierFactory().getIdentifierTruncatedToAdapterColumnLength(orderStr);
                        orderStr = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase(orderStr);
                        this.addOrderComponent(orderStmt, orderStr, orderExpr, orderDirection, orderNullDirective, dba);
                        continue;
                    }
                    this.addOrderComponent(orderStmt, orderExpr.toSQLText().toSQL(), orderExpr, orderDirection, orderNullDirective, dba);
                }
            }
        }
        return orderStmt;
    }

    protected void addOrderComponent(SQLText orderST, String orderString, SQLExpression orderExpr, boolean orderDirection, NullOrderingType orderNullDirective, DatastoreAdapter dba) {
        String orderParam = dba.getOrderString((StoreManager)this.rdbmsMgr, orderString, orderExpr);
        if (orderNullDirective != null) {
            if (dba.supportsOption("OrderByWithNullsDirectives")) {
                orderST.append(orderParam).append(orderDirection ? " DESC" : "").append(orderNullDirective == NullOrderingType.NULLS_FIRST ? " NULLS FIRST" : " NULLS LAST");
            } else if (dba.supportsOption("OrderByNullsUsingCaseNull")) {
                String caseWhenOrderParam = orderExpr.toSQLText().toSQL();
                if (orderExpr instanceof ResultAliasExpression) {
                    SelectStatement orderExprStmt = (SelectStatement)orderExpr.getSQLStatement();
                    String selectAlias = ((ResultAliasExpression)orderExpr).getResultAlias();
                    for (int i = 0; i < orderExprStmt.selectedItems.size(); ++i) {
                        SelectedItem item = orderExprStmt.selectedItems.get(i);
                        if (!selectAlias.equalsIgnoreCase(item.getAlias())) continue;
                        caseWhenOrderParam = item.getSQLText().toSQL();
                        break;
                    }
                }
                orderST.append("(CASE WHEN " + caseWhenOrderParam + " IS NULL THEN 1 ELSE 0 END)").append(orderNullDirective == NullOrderingType.NULLS_FIRST ? " DESC" : " ASC").append(",");
                orderST.append(orderParam).append(orderDirection ? " DESC" : "");
            } else if (dba.supportsOption("OrderByNullsUsingColumnIsNull")) {
                if (orderExpr.getSQLTable() != null) {
                    orderST.append(orderParam).append(" IS NULL").append(orderNullDirective == NullOrderingType.NULLS_FIRST ? " DESC" : " ASC").append(",");
                }
                orderST.append(orderParam).append(orderDirection ? " DESC" : "");
            } else if (dba.supportsOption("OrderByNullsUsingIsNull")) {
                if (orderExpr.getSQLTable() != null) {
                    orderST.append("ISNULL(").append(orderParam).append(")").append(orderNullDirective == NullOrderingType.NULLS_FIRST ? " DESC" : " ASC").append(",");
                }
                orderST.append(orderParam).append(orderDirection ? " DESC" : "");
            } else {
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Query contains NULLS directive yet this datastore doesn't provide any support for handling this. Nulls directive will be ignored");
                orderST.append(orderParam).append(orderDirection ? " DESC" : "");
            }
        } else {
            orderST.append(orderParam).append(orderDirection ? " DESC" : "");
        }
    }

    protected void addOrderingColumnsToSelect() {
        block8: {
            DatastoreAdapter dba;
            block9: {
                if (this.orderingExpressions == null || this.parent != null) break block8;
                dba = this.getDatastoreAdapter();
                if (!dba.supportsOption("OrderByUsingSelectColumnIndex")) break block9;
                this.orderingColumnIndexes = new int[this.orderingExpressions.length];
                for (int i = 0; i < this.orderingExpressions.length; ++i) {
                    this.orderingColumnIndexes[i] = this.selectItem(this.orderingExpressions[i].toSQLText(), null, !this.aggregated);
                    if (this.unions == null || !this.allowUnions) continue;
                    for (SelectStatement stmt : this.unions) {
                        stmt.selectItem(this.orderingExpressions[i].toSQLText(), null, !this.aggregated);
                    }
                }
                break block8;
            }
            if (!dba.supportsOption("IncludeOrderByColumnsInSelect")) break block8;
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                if (this.orderingExpressions[i] instanceof ResultAliasExpression) continue;
                if (this.orderingExpressions[i].getNumberOfSubExpressions() == 1 || this.aggregated) {
                    String orderExprAlias = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase("NUCORDER" + i);
                    if (this.unions != null && this.allowUnions) {
                        for (SelectStatement stmt : this.unions) {
                            stmt.selectItem(this.orderingExpressions[i].toSQLText(), this.aggregated ? null : orderExprAlias, !this.aggregated);
                        }
                    }
                    this.selectItem(this.orderingExpressions[i].toSQLText(), this.aggregated ? null : orderExprAlias, !this.aggregated);
                    continue;
                }
                JavaTypeMapping m = this.orderingExpressions[i].getJavaTypeMapping();
                ColumnMapping[] mappings = m.getColumnMappings();
                for (int j = 0; j < mappings.length; ++j) {
                    String alias = this.rdbmsMgr.getIdentifierFactory().getIdentifierInAdapterCase("NUCORDER" + i + "_" + j);
                    DatastoreIdentifier aliasId = this.rdbmsMgr.getIdentifierFactory().newColumnIdentifier(alias);
                    SQLColumn col = new SQLColumn(this.orderingExpressions[i].getSQLTable(), mappings[j].getColumn(), aliasId);
                    this.selectItem(new SQLText(col.getColumnSelectString()), alias, !this.aggregated);
                    if (this.unions == null || !this.allowUnions) continue;
                    for (SelectStatement stmt : this.unions) {
                        stmt.selectItem(new SQLText(col.getColumnSelectString()), alias, !this.aggregated);
                    }
                }
            }
        }
    }

    public void setAllowUnions(boolean flag) {
        this.allowUnions = flag;
    }

    public int getNumberOfUnions() {
        if (this.unions == null || !this.allowUnions) {
            return 0;
        }
        int number = this.unions.size();
        for (SelectStatement unioned : this.unions) {
            number += unioned.getNumberOfUnions();
        }
        return number;
    }

    public List<SelectStatement> getUnions() {
        return this.allowUnions ? this.unions : null;
    }

    public void union(SelectStatement stmt) {
        this.invalidateStatement();
        if (this.unions == null) {
            this.unions = new ArrayList<SelectStatement>();
        }
        this.unions.add(stmt);
    }

    public boolean allUnionsForSamePrimaryTable() {
        if (this.unions != null && this.allowUnions) {
            for (SQLStatement sQLStatement : this.unions) {
                if (sQLStatement.getPrimaryTable().equals(this.primaryTable)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public SQLTable join(SQLJoin.JoinType joinType, SQLTable sourceTable, JavaTypeMapping sourceMapping, JavaTypeMapping sourceParentMapping, Table target, String targetAlias, JavaTypeMapping targetMapping, JavaTypeMapping targetParentMapping, Object[] discrimValues, String tableGrpName, boolean applyToUnions, SQLJoin parentJoin) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.namer.getAliasForTable(this, target, (String)tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, (String)tableGrpName);
        this.putSQLTableInGroup(targetTbl, (String)tableGrpName, joinType);
        BooleanExpression joinCondition = this.getJoinConditionForJoin(sourceTable, sourceMapping, sourceParentMapping, targetTbl, targetMapping, targetParentMapping, discrimValues);
        this.addJoin(joinType, sourceTable, targetTbl, joinCondition, parentJoin);
        if (this.unions != null && applyToUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.join(joinType, sourceTable, sourceMapping, sourceParentMapping, target, targetAlias, targetMapping, targetParentMapping, discrimValues, (String)tableGrpName, true, parentJoin);
            }
        }
        return targetTbl;
    }

    @Override
    public SQLTable join(SQLJoin.JoinType joinType, SQLTable sourceTable, Table target, String targetAlias, String tableGrpName, BooleanExpression joinCondition, boolean applyToUnions) {
        this.invalidateStatement();
        if (this.tables == null) {
            this.tables = new HashMap();
        }
        if (tableGrpName == null) {
            tableGrpName = "Group" + this.tableGroups.size();
        }
        if (targetAlias == null) {
            targetAlias = this.namer.getAliasForTable(this, target, (String)tableGrpName);
        }
        if (sourceTable == null) {
            sourceTable = this.primaryTable;
        }
        DatastoreIdentifier targetId = this.rdbmsMgr.getIdentifierFactory().newTableIdentifier(targetAlias);
        SQLTable targetTbl = new SQLTable(this, target, targetId, (String)tableGrpName);
        this.putSQLTableInGroup(targetTbl, (String)tableGrpName, joinType);
        this.addJoin(joinType, sourceTable, targetTbl, joinCondition, null);
        if (this.unions != null && applyToUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.join(joinType, sourceTable, target, targetAlias, (String)tableGrpName, joinCondition, true);
            }
        }
        return targetTbl;
    }

    @Override
    public String removeCrossJoin(SQLTable targetSqlTbl) {
        if (this.joins == null) {
            return null;
        }
        Iterator joinIter = this.joins.iterator();
        while (joinIter.hasNext()) {
            SQLJoin join = (SQLJoin)joinIter.next();
            if (!join.getTargetTable().equals(targetSqlTbl) || join.getType() != SQLJoin.JoinType.CROSS_JOIN) continue;
            joinIter.remove();
            this.requiresJoinReorder = true;
            this.tables.remove(join.getTargetTable().alias.getName());
            String removedAliasName = join.getTargetTable().alias.getName();
            if (this.unions != null) {
                for (SelectStatement stmt : this.unions) {
                    stmt.removeCrossJoin(targetSqlTbl);
                }
            }
            return removedAliasName;
        }
        return null;
    }

    @Override
    public void whereAnd(BooleanExpression expr, boolean applyToUnions) {
        if (expr instanceof BooleanLiteral && !expr.isParameter() && ((Boolean)((BooleanLiteral)expr).getValue()).booleanValue()) {
            return;
        }
        super.whereAnd(expr, false);
        if (this.unions != null && this.allowUnions && applyToUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.whereAnd(expr, true);
            }
        }
    }

    @Override
    public void whereOr(BooleanExpression expr, boolean applyToUnions) {
        super.whereOr(expr, false);
        if (this.unions != null && this.allowUnions && applyToUnions) {
            for (SelectStatement stmt : this.unions) {
                stmt.whereOr(expr, true);
            }
        }
    }

    protected class SelectedItem {
        SQLText sqlText;
        String alias;
        boolean primary = true;

        public SelectedItem(SQLText st, String alias, boolean primary) {
            this.sqlText = st;
            this.alias = alias;
            this.primary = primary;
        }

        public SQLText getSQLText() {
            return this.sqlText;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public int hashCode() {
            return this.sqlText.hashCode() ^ (this.alias != null ? this.alias.hashCode() : 0);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof SelectedItem)) {
                return false;
            }
            SelectedItem otherItem = (SelectedItem)other;
            if (!this.sqlText.equals(otherItem.sqlText)) {
                return false;
            }
            return (this.alias == null || this.alias.equals(otherItem.alias)) && (otherItem.alias == null || otherItem.alias.equals(this.alias));
        }
    }
}

