/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class IntegerMapping
extends SingleFieldMapping {
    @Override
    public Class getJavaType() {
        return Integer.class;
    }

    @Override
    public Object[] getValidValues(int index) {
        if (this.mmd != null && this.mmd.hasExtension("check-constraint-values")) {
            String valuesStr = this.mmd.getValueForExtension("check-constraint-values");
            String[] stringValues = StringUtils.split((String)valuesStr, (String)",");
            Object[] values = new Integer[stringValues.length];
            for (int i = 0; i < stringValues.length; ++i) {
                try {
                    values[i] = Integer.valueOf(stringValues[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    NucleusLogger.GENERAL.warn((Object)("Member " + this.mmd.getFullFieldName() + " has check constraint value that is not an integer! (" + stringValues[i] + "). Values are ignored"));
                    return null;
                }
            }
            return values;
        }
        return super.getValidValues(index);
    }
}

