/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class DBCP2ConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        GenericObjectPool connectionPool;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, clr);
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.pool2.ObjectPool", (String)"commons-pool-2.x.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.dbcp2.ConnectionFactory", (String)"commons-dbcp-2.x.jar");
        PoolingDataSource ds = null;
        String dbURL = storeMgr.getConnectionURL();
        try {
            int value;
            int validationTimeout;
            Properties dbProps = DBCP2ConnectionPoolFactory.getPropertiesForDriver(storeMgr);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbProps);
            PoolableConnectionFactory poolableCF = null;
            poolableCF = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
            String testSQL = null;
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TEST_SQL)) {
                testSQL = storeMgr.getStringProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TEST_SQL);
                poolableCF.setValidationQuery(testSQL);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_VALIDATION_TIMEOUT) && (validationTimeout = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_VALIDATION_TIMEOUT)) >= 0) {
                poolableCF.setValidationQueryTimeout(validationTimeout);
            }
            connectionPool = new GenericObjectPool((PooledObjectFactory)poolableCF);
            poolableCF.setPool((ObjectPool)connectionPool);
            if (testSQL != null) {
                connectionPool.setTestOnBorrow(true);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_IDLE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_IDLE)) > 0) {
                connectionPool.setMaxIdle(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_IDLE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_IDLE)) > 0) {
                connectionPool.setMinIdle(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_ACTIVE) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_ACTIVE)) > 0) {
                connectionPool.setMaxTotal(value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_WAIT) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MAX_WAIT)) > 0) {
                connectionPool.setMaxWaitMillis((long)value);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TIME_BETWEEN_EVICTOR_RUNS_MILLIS) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_TIME_BETWEEN_EVICTOR_RUNS_MILLIS)) > 0) {
                connectionPool.setTimeBetweenEvictionRunsMillis((long)value);
                int maxIdle = connectionPool.getMaxIdle();
                int numTestsPerEvictionRun = (int)Math.ceil((double)maxIdle / 4.0);
                connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
            }
            if (storeMgr.hasProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS) && (value = storeMgr.getIntProperty(RDBMSPropertyNames.PROPERTY_CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS)) > 0) {
                connectionPool.setMinEvictableIdleTimeMillis((long)value);
            }
            ds = new PoolingDataSource((ObjectPool)connectionPool);
        }
        catch (Exception e) {
            throw new DatastorePoolException("DBCP2", dbDriver, dbURL, e);
        }
        return new DBCPConnectionPool(ds, (ObjectPool)connectionPool);
    }

    public class DBCPConnectionPool
    implements ConnectionPool {
        final PoolingDataSource dataSource;
        final ObjectPool pool;

        public DBCPConnectionPool(PoolingDataSource ds, ObjectPool pool) {
            this.dataSource = ds;
            this.pool = pool;
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

