/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.util.Map;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.transaction.Synchronization;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.api.jdo.exceptions.TransactionActiveException;
import org.datanucleus.api.jdo.exceptions.TransactionCommitingException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.transaction.TransactionUtils;

public class JDOTransaction
implements javax.jdo.Transaction {
    Transaction tx;
    JDOPersistenceManager pm;

    public JDOTransaction(JDOPersistenceManager pm, Transaction tx) {
        this.tx = tx;
        this.pm = pm;
    }

    public JDOPersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public boolean isActive() {
        return this.tx.isActive();
    }

    public void begin() {
        if (this.pm.isClosed()) {
            // empty if block
        }
        this.tx.begin();
    }

    public void commit() {
        try {
            this.tx.commit();
        }
        catch (NucleusException ne) {
            if (ne.getNestedExceptions() != null) {
                if (ne.getNestedExceptions()[0] instanceof NucleusOptimisticException) {
                    if (ne.getNestedExceptions().length > 1) {
                        int numNested = ne.getNestedExceptions().length;
                        JDOOptimisticVerificationException[] jdoNested = new JDOOptimisticVerificationException[numNested];
                        for (int i = 0; i < numNested; ++i) {
                            NucleusOptimisticException nested = (NucleusOptimisticException)ne.getNestedExceptions()[i];
                            jdoNested[i] = (JDOOptimisticVerificationException)NucleusJDOHelper.getJDOExceptionForNucleusException((NucleusException)nested);
                        }
                        throw new JDOOptimisticVerificationException(ne.getMessage(), (Throwable[])jdoNested);
                    }
                    NucleusException ex = ne.getNestedExceptions()[0] instanceof NucleusException ? (NucleusException)ne.getNestedExceptions()[0] : new NucleusException(ne.getNestedExceptions()[0].getMessage(), ne.getNestedExceptions()[0]);
                    Throwable[] nested = ex.getNestedExceptions();
                    JDOOptimisticVerificationException[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                    for (int i = 0; i < nested.length; ++i) {
                        NucleusException nestedEx = nested[i] instanceof NucleusException ? (NucleusException)nested[i] : new NucleusException(nested[i].getMessage(), nested[i]);
                        jdoNested[i] = (JDOOptimisticVerificationException)NucleusJDOHelper.getJDOExceptionForNucleusException(nestedEx);
                    }
                    throw new JDOOptimisticVerificationException(ne.getMessage(), (Throwable[])jdoNested);
                }
                NucleusException ex = ne.getNestedExceptions()[0] instanceof NucleusException ? (NucleusException)ne.getNestedExceptions()[0] : new NucleusException(ne.getNestedExceptions()[0].getMessage(), ne.getNestedExceptions()[0]);
                throw NucleusJDOHelper.getJDOExceptionForNucleusException(ex);
            }
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    public void rollback() {
        try {
            this.tx.rollback();
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    public boolean getNontransactionalRead() {
        return this.tx.getNontransactionalRead();
    }

    public boolean getNontransactionalWrite() {
        return this.tx.getNontransactionalWrite();
    }

    public boolean getNontransactionalWriteAutoCommit() {
        return this.tx.getNontransactionalWriteAutoCommit();
    }

    public boolean getOptimistic() {
        return this.tx.getOptimistic();
    }

    public boolean getRestoreValues() {
        return this.tx.getRestoreValues();
    }

    public boolean getRetainValues() {
        return this.tx.getRetainValues();
    }

    public boolean getRollbackOnly() {
        return this.tx.getRollbackOnly();
    }

    public Synchronization getSynchronization() {
        return this.tx.getSynchronization();
    }

    public void setNontransactionalRead(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalRead(flag);
    }

    public void setNontransactionalWrite(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalWrite(flag);
    }

    public void setNontransactionalWriteAutoCommit(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalWriteAutoCommit(flag);
    }

    public void setOptimistic(boolean opt) {
        this.assertNotInUse();
        this.assertNotCommitting();
        this.tx.setOptimistic(opt);
    }

    public void setRestoreValues(boolean restore) {
        this.assertNotInUse();
        this.assertNotCommitting();
        this.tx.setRestoreValues(restore);
    }

    public void setRetainValues(boolean retain) {
        this.assertNotCommitting();
        this.tx.setRetainValues(retain);
    }

    public void setRollbackOnly() {
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        }
    }

    public void setSynchronization(Synchronization synch) {
        this.tx.setSynchronization(synch);
    }

    public void setIsolationLevel(String level) {
        this.assertNotCommitting();
        if (this.tx.isActive() && !this.tx.getOptimistic()) {
            throw new JDOUnsupportedOptionException("Cannot change the transaction isolation level while a datastore transaction is active");
        }
        JDOPersistenceManagerFactory pmf = this.pm.getPersistenceManagerFactory();
        if (!pmf.supportedOptions().contains("javax.jdo.option.TransactionIsolationLevel." + level)) {
            throw new JDOUnsupportedOptionException("Isolation level \"" + level + "\" not supported by this datastore");
        }
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName((String)level);
        this.tx.setOption("transaction.isolation", isolationLevel);
    }

    public String getIsolationLevel() {
        Object value;
        Map txOptions = this.tx.getOptions();
        Object v0 = value = txOptions != null ? txOptions.get("transaction.isolation") : null;
        if (value != null) {
            return TransactionUtils.getNameForTransactionIsolationLevel((int)((Integer)value).intValue());
        }
        return null;
    }

    public void setSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot set savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot set savepoint");
        }
        this.tx.setSavepoint(name);
    }

    public void releaseSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot release savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot release a savepoint");
        }
        this.tx.releaseSavepoint(name);
    }

    public void rollbackToSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot rollback to savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot rollback to savepoint");
        }
        this.tx.rollbackToSavepoint(name);
    }

    protected void assertNotCommitting() {
        if (this.tx.isCommitting()) {
            throw new TransactionCommitingException(this);
        }
    }

    protected void assertNotInUse() {
        if (this.tx.isActive()) {
            throw new TransactionActiveException(this);
        }
    }

    public Boolean getSerializeRead() {
        return this.tx.getSerializeRead();
    }

    public void setSerializeRead(Boolean serialize) {
        this.assertNotCommitting();
        this.tx.setSerializeRead(serialize);
    }

    public void setOption(String option, int value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, boolean value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, String value) {
        this.tx.setOption(option, value);
    }

    public void registerEventListener(TransactionEventListener listener) {
        this.tx.bindTransactionEventListener(listener);
    }

    public void deregisterEventListener(TransactionEventListener listener) {
        this.tx.removeTransactionEventListener(listener);
    }
}

