/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyCollectorBuilder;
import org.cyclonedx.maven.DefaultModelConverter;
import org.cyclonedx.maven.DelegatingRepositorySystem;
import org.cyclonedx.maven.ModelConverter;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Metadata;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.DependencyNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultProjectDependenciesConverter
implements ProjectDependenciesConverter {
    private final Logger logger = LoggerFactory.getLogger(DefaultModelConverter.class);
    @Inject
    private MavenSession session;
    @Inject
    private ModelConverter modelConverter;
    @Inject
    private RepositorySystem aetherRepositorySystem;
    private Set<String> excludeTypesSet;
    private ProjectDependenciesConverter.MavenDependencyScopes include;

    @Override
    public Set<Dependency> extractBOMDependencies(MavenProject mavenProject, ProjectDependenciesConverter.MavenDependencyScopes include, String[] excludeTypes) throws MojoExecutionException {
        this.include = include;
        this.excludeTypesSet = new HashSet<String>(Arrays.asList(excludeTypes));
        ProjectBuildingRequest buildingRequest = this.getProjectBuildingRequest(mavenProject);
        Map<String, String> resolvedPUrls = this.generateResolvedPUrls(mavenProject);
        LinkedHashMap<Dependency, Dependency> dependencies = new LinkedHashMap<Dependency, Dependency>();
        try {
            DelegatingRepositorySystem delegateRepositorySystem = new DelegatingRepositorySystem(this.aetherRepositorySystem);
            DefaultDependencyCollectorBuilder dependencyCollectorBuilder = new DefaultDependencyCollectorBuilder((RepositorySystem)delegateRepositorySystem);
            dependencyCollectorBuilder.collectDependencyGraph(buildingRequest, null);
            CollectResult collectResult = delegateRepositorySystem.getCollectResult();
            if (collectResult == null) {
                throw new MojoExecutionException("Failed to generate aether dependency graph");
            }
            DependencyNode root = collectResult.getRoot();
            HashSet<String> loggedReplacementPUrls = new HashSet<String>();
            HashSet<String> loggedFilteredArtifacts = new HashSet<String>();
            this.buildDependencyGraphNode(dependencies, root, null, null, resolvedPUrls, loggedReplacementPUrls, loggedFilteredArtifacts);
        }
        catch (DependencyCollectorBuilderException e) {
            this.logger.warn("An error occurred building dependency graph: " + e.getMessage());
        }
        return dependencies.keySet();
    }

    private boolean isFilteredNode(DependencyNode node, Set<String> loggedFilteredArtifacts) {
        String purl;
        String key;
        Boolean scoped;
        Map nodeData = node.getData();
        String originalScope = (String)nodeData.get("conflict.originalScope");
        String scope = originalScope != null ? originalScope : node.getDependency().getScope();
        switch (scope) {
            case "compile": {
                scoped = this.include.compile;
                break;
            }
            case "provided": {
                scoped = this.include.provided;
                break;
            }
            case "runtime": {
                scoped = this.include.runtime;
                break;
            }
            case "system": {
                scoped = this.include.system;
                break;
            }
            case "test": {
                scoped = this.include.test;
                break;
            }
            default: {
                scoped = Boolean.FALSE;
            }
        }
        boolean result = Boolean.FALSE.equals(scoped);
        if (result && loggedFilteredArtifacts.add(key = (purl = this.modelConverter.generatePackageUrl(node.getArtifact())) + ":" + originalScope + ":" + node.getDependency().getScope()) && this.logger.isDebugEnabled()) {
            this.logger.debug("Filtering " + purl + " with original scope " + originalScope + " and scope " + node.getDependency().getScope());
        }
        return result;
    }

    private boolean isExcludedNode(DependencyNode node) {
        String type = (String)node.getArtifact().getProperties().get("type");
        return type == null || this.excludeTypesSet.contains(type);
    }

    private void buildDependencyGraphNode(Map<Dependency, Dependency> dependencies, DependencyNode node, Dependency parent, String parentClassifierlessPUrl, Map<String, String> resolvedPUrls, Set<String> loggedReplacementPUrls, Set<String> loggedFilteredArtifacts) {
        String nodeClassifierlessPUrl;
        Dependency topDependency;
        Dependency origDependency;
        String purl = this.modelConverter.generatePackageUrl(node.getArtifact());
        if (this.isExcludedNode(node) || parent != null && this.isFilteredNode(node, loggedFilteredArtifacts)) {
            return;
        }
        if (node.getChildren().isEmpty()) {
            Map nodeData = node.getData();
            DependencyNode winner = (DependencyNode)nodeData.get("conflict.winner");
            String resolvedPurl = resolvedPUrls.get(this.modelConverter.generateVersionlessPackageUrl(node.getArtifact()));
            if (!purl.equals(resolvedPurl)) {
                if (!loggedReplacementPUrls.contains(purl)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Replacing reference to " + purl + " with resolved package url " + resolvedPurl);
                    }
                    loggedReplacementPUrls.add(purl);
                }
                purl = resolvedPurl;
            }
            if (winner != null) {
                node = winner;
            }
        }
        if ((origDependency = dependencies.putIfAbsent(topDependency = new Dependency(purl), topDependency)) != null) {
            topDependency = origDependency;
        }
        if (parent != null) {
            parent.addDependency(new Dependency(purl));
        }
        if (!(nodeClassifierlessPUrl = this.modelConverter.generateClassifierlessPackageUrl(node.getArtifact())).equals(parentClassifierlessPUrl)) {
            for (DependencyNode childrenNode : node.getChildren()) {
                this.buildDependencyGraphNode(dependencies, childrenNode, topDependency, nodeClassifierlessPUrl, resolvedPUrls, loggedReplacementPUrls, loggedFilteredArtifacts);
            }
        }
    }

    private Map<String, String> generateResolvedPUrls(MavenProject mavenProject) {
        HashMap<String, String> resolvedPUrls = new HashMap<String, String>();
        Artifact projectArtifact = mavenProject.getArtifact();
        resolvedPUrls.put(this.modelConverter.generateVersionlessPackageUrl(projectArtifact), this.modelConverter.generatePackageUrl(projectArtifact));
        for (Artifact artifact : mavenProject.getArtifacts()) {
            resolvedPUrls.put(this.modelConverter.generateVersionlessPackageUrl(artifact), this.modelConverter.generatePackageUrl(artifact));
        }
        return resolvedPUrls;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(MavenProject mavenProject) {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setProject(mavenProject);
        return buildingRequest;
    }

    @Override
    public void cleanupBomDependencies(Metadata metadata, Set<Component> components, Set<Dependency> dependencies) {
        HashMap<String, Component> componentRefs = new HashMap<String, Component>();
        components.forEach(c -> componentRefs.put(c.getBomRef(), (Component)c));
        HashSet dependencyRefs = new HashSet();
        HashSet dependsOns = new HashSet();
        dependencies.forEach(d -> {
            dependencyRefs.add(d.getRef());
            if (d.getDependencies() != null) {
                d.getDependencies().forEach(on -> dependsOns.add(on.getRef()));
            }
        });
        for (Map.Entry entry : componentRefs.entrySet()) {
            if (!dependencyRefs.contains(entry.getKey())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Component reference not listed in dependencies, pruning from bom components: " + (String)entry.getKey());
                }
                components.remove(entry.getValue());
                continue;
            }
            if (dependsOns.contains(entry.getKey())) continue;
            this.logger.warn("BOM dependency listed but is not depended upon: " + (String)entry.getKey());
        }
        Component main = metadata.getComponent();
        componentRefs.put(main.getBomRef(), main);
        for (String dependencyRef : dependencyRefs) {
            if (componentRefs.containsKey(dependencyRef)) continue;
            this.logger.warn("Dependency missing component entry: " + dependencyRef);
        }
    }
}

