/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.line;

import org.crsh.cli.impl.line.Quoting;

public final class LineParser {
    private static final int NORMAL = 0;
    private static final int WEAK_QUOTING = 1;
    private static final int STRONG_QUOTING = 2;
    private int status = 0;
    private boolean escaped = false;
    private int index = 0;
    private final Visitor[] visitors;

    public LineParser(Visitor ... visitors) {
        this.visitors = visitors;
    }

    public boolean crlf() {
        if (this.escaped) {
            this.escaped = false;
            return false;
        }
        switch (this.status) {
            case 1: {
                for (Visitor visitor : this.visitors) {
                    visitor.onChar(this.index, Quoting.WEAK, false, '\n');
                }
                ++this.index;
                return false;
            }
            case 2: {
                for (Visitor visitor : this.visitors) {
                    visitor.onChar(this.index, Quoting.STRONG, false, '\n');
                }
                ++this.index;
                return false;
            }
        }
        return true;
    }

    public LineParser append(CharSequence s) {
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            this.append(s.charAt(index));
        }
        return this;
    }

    public LineParser append(char c) {
        if (!this.escaped) {
            block0 : switch (this.status) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            this.escaped = true;
                            break block0;
                        }
                        case '\"': {
                            for (Visitor visitor : this.visitors) {
                                visitor.openWeakQuote(this.index);
                            }
                            this.status = 1;
                            ++this.index;
                            break block0;
                        }
                        case '\'': {
                            for (Visitor visitor : this.visitors) {
                                visitor.openStrongQuote(this.index);
                            }
                            ++this.index;
                            this.status = 2;
                            break block0;
                        }
                    }
                    for (Visitor visitor : this.visitors) {
                        visitor.onChar(this.index, null, false, c);
                    }
                    ++this.index;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\"': {
                            for (Visitor visitor : this.visitors) {
                                visitor.closeWeakQuote(this.index);
                            }
                            ++this.index;
                            this.status = 0;
                            break block0;
                        }
                        case '\\': {
                            this.escaped = true;
                            break block0;
                        }
                    }
                    for (Visitor visitor : this.visitors) {
                        visitor.onChar(this.index, Quoting.WEAK, false, c);
                    }
                    ++this.index;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            for (Visitor visitor : this.visitors) {
                                visitor.closeStrongQuote(this.index);
                            }
                            ++this.index;
                            this.status = 0;
                            break block0;
                        }
                        case '\\': {
                            this.escaped = true;
                            break block0;
                        }
                    }
                    for (Visitor visitor : this.visitors) {
                        visitor.onChar(this.index, Quoting.STRONG, false, c);
                    }
                    ++this.index;
                }
            }
        } else {
            switch (this.status) {
                case 0: {
                    for (Visitor visitor : this.visitors) {
                        visitor.onChar(this.index + 1, null, true, c);
                    }
                    this.index += 2;
                    break;
                }
                case 1: {
                    for (Visitor visitor : this.visitors) {
                        visitor.onChar(this.index + 1, Quoting.WEAK, true, c);
                    }
                    this.index += 2;
                    break;
                }
                case 2: {
                    if (c == '\'') {
                        this.status = 0;
                        for (Visitor visitor : this.visitors) {
                            visitor.onChar(this.index, Quoting.STRONG, false, '\\');
                        }
                        for (Visitor visitor : this.visitors) {
                            visitor.closeStrongQuote(this.index + 1);
                        }
                        this.index += 2;
                        break;
                    }
                    for (Visitor visitor : this.visitors) {
                        visitor.onChar(this.index + 1, Quoting.STRONG, true, c);
                    }
                    this.index += 2;
                }
            }
            this.escaped = false;
        }
        return this;
    }

    public void reset() {
        this.index = 0;
        this.status = 0;
        this.escaped = false;
        for (Visitor visitor : this.visitors) {
            visitor.reset();
        }
    }

    public static abstract class Visitor {
        public void onChar(int index, Quoting quoting, boolean backslash, char c) {
        }

        public void openStrongQuote(int index) {
        }

        public void closeStrongQuote(int index) {
        }

        public void openWeakQuote(int index) {
        }

        public void closeWeakQuote(int index) {
        }

        public void reset() {
        }
    }
}

