/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.coursera.metrics.datadog.AwsHelper;
import org.coursera.metrics.datadog.DefaultMetricNameFormatter;
import org.coursera.metrics.datadog.DynamicTagsCallback;
import org.coursera.metrics.datadog.MetricNameFormatter;
import org.coursera.metrics.datadog.TagUtils;
import org.coursera.metrics.datadog.model.DatadogCounter;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.datadog.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatadogReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(DatadogReporter.class);
    private static final Expansion[] STATS_EXPANSIONS = new Expansion[]{Expansion.MAX, Expansion.MEAN, Expansion.MIN, Expansion.STD_DEV, Expansion.MEDIAN, Expansion.P75, Expansion.P95, Expansion.P98, Expansion.P99, Expansion.P999};
    private static final Expansion[] RATE_EXPANSIONS = new Expansion[]{Expansion.RATE_1_MINUTE, Expansion.RATE_5_MINUTE, Expansion.RATE_15_MINUTE, Expansion.RATE_MEAN};
    private final Transport transport;
    private final Clock clock;
    private final String host;
    private final EnumSet<Expansion> expansions;
    private final MetricNameFormatter metricNameFormatter;
    private final List<String> tags;
    private final String prefix;
    private final DynamicTagsCallback tagsCallback;
    private Transport.Request request;

    private DatadogReporter(MetricRegistry metricRegistry, Transport transport, MetricFilter filter, Clock clock, String host, EnumSet<Expansion> expansions, TimeUnit rateUnit, TimeUnit durationUnit, MetricNameFormatter metricNameFormatter, List<String> tags, String prefix, DynamicTagsCallback tagsCallback) {
        super(metricRegistry, "datadog-reporter", filter, rateUnit, durationUnit);
        this.clock = clock;
        this.host = host;
        this.expansions = expansions;
        this.metricNameFormatter = metricNameFormatter;
        this.tags = tags == null ? new ArrayList() : tags;
        this.transport = transport;
        this.prefix = prefix;
        this.tagsCallback = tagsCallback;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        List<String> dynamicTags;
        long timestamp = this.clock.getTime() / 1000L;
        List<String> newTags = this.tags;
        if (this.tagsCallback != null && (dynamicTags = this.tagsCallback.getTags()) != null && !dynamicTags.isEmpty()) {
            newTags = TagUtils.mergeTags(this.tags, dynamicTags);
        }
        try {
            this.request = this.transport.prepare();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(this.prefix(entry.getKey()), entry.getValue(), timestamp, newTags);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(this.prefix(entry.getKey()), (Counter)entry.getValue(), timestamp, newTags);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(this.prefix(entry.getKey()), (Histogram)entry.getValue(), timestamp, newTags);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMetered(this.prefix(entry.getKey()), (Metered)entry.getValue(), timestamp, newTags);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(this.prefix(entry.getKey()), (Timer)entry.getValue(), timestamp, newTags);
            }
            this.request.send();
        }
        catch (Throwable e) {
            LOG.error("Error reporting metrics to Datadog", e);
        }
    }

    private void reportTimer(String name, Timer timer, long timestamp, List<String> tags) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        double[] values = new double[]{snapshot.getMax(), snapshot.getMean(), snapshot.getMin(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile()};
        for (int i = 0; i < STATS_EXPANSIONS.length; ++i) {
            if (!this.expansions.contains((Object)STATS_EXPANSIONS[i])) continue;
            this.request.addGauge(new DatadogGauge(this.appendExpansionSuffix(name, STATS_EXPANSIONS[i]), this.toNumber(this.convertDuration(values[i])), (Long)timestamp, this.host, tags));
        }
        this.reportMetered(name, (Metered)timer, timestamp, tags);
    }

    private void reportMetered(String name, Metered meter, long timestamp, List<String> tags) throws IOException {
        if (this.expansions.contains((Object)Expansion.COUNT)) {
            this.request.addCounter(new DatadogCounter(this.appendExpansionSuffix(name, Expansion.COUNT), meter.getCount(), (Long)timestamp, this.host, tags));
        }
        double[] values = new double[]{meter.getOneMinuteRate(), meter.getFiveMinuteRate(), meter.getFifteenMinuteRate(), meter.getMeanRate()};
        for (int i = 0; i < RATE_EXPANSIONS.length; ++i) {
            if (!this.expansions.contains((Object)RATE_EXPANSIONS[i])) continue;
            this.request.addGauge(new DatadogGauge(this.appendExpansionSuffix(name, RATE_EXPANSIONS[i]), this.toNumber(this.convertRate(values[i])), (Long)timestamp, this.host, tags));
        }
    }

    private void reportHistogram(String name, Histogram histogram, long timestamp, List<String> tags) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        if (this.expansions.contains((Object)Expansion.COUNT)) {
            this.request.addCounter(new DatadogCounter(this.appendExpansionSuffix(name, Expansion.COUNT), histogram.getCount(), (Long)timestamp, this.host, tags));
        }
        Number[] values = new Number[]{snapshot.getMax(), snapshot.getMean(), snapshot.getMin(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile()};
        for (int i = 0; i < STATS_EXPANSIONS.length; ++i) {
            if (!this.expansions.contains((Object)STATS_EXPANSIONS[i])) continue;
            this.request.addGauge(new DatadogGauge(this.appendExpansionSuffix(name, STATS_EXPANSIONS[i]), this.toNumber(values[i]), (Long)timestamp, this.host, tags));
        }
    }

    private void reportCounter(String name, Counter counter, long timestamp, List<String> tags) throws IOException {
        this.request.addGauge(new DatadogGauge(name, counter.getCount(), (Long)timestamp, this.host, tags));
    }

    private void reportGauge(String name, Gauge gauge, long timestamp, List<String> tags) throws IOException {
        Number value = this.toNumber(gauge.getValue());
        if (value != null) {
            this.request.addGauge(new DatadogGauge(name, value, (Long)timestamp, this.host, tags));
        }
    }

    private Number toNumber(Object o) {
        if (o instanceof Number) {
            return (Number)o;
        }
        return null;
    }

    private String appendExpansionSuffix(String name, Expansion expansion) {
        return this.metricNameFormatter.format(name, expansion.toString());
    }

    private String prefix(String name) {
        if (this.prefix == null) {
            return name;
        }
        return String.format("%s.%s", this.prefix, name);
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final MetricRegistry registry;
        private String host;
        private EnumSet<Expansion> expansions;
        private Clock clock;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private MetricNameFormatter metricNameFormatter;
        private List<String> tags;
        private Transport transport;
        private String prefix;
        private DynamicTagsCallback tagsCallback;

        public Builder(MetricRegistry registry) {
            this.registry = registry;
            this.expansions = Expansion.ALL;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.metricNameFormatter = new DefaultMetricNameFormatter();
            this.tags = new ArrayList<String>();
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withEC2Host() throws IOException {
            this.host = AwsHelper.getEc2InstanceId();
            return this;
        }

        public Builder withExpansions(EnumSet<Expansion> expansions) {
            this.expansions = expansions;
            return this;
        }

        public Builder withDynamicTagCallback(DynamicTagsCallback tagsCallback) {
            this.tagsCallback = tagsCallback;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withMetricNameFormatter(MetricNameFormatter formatter) {
            this.metricNameFormatter = formatter;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder withTransport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public DatadogReporter build() {
            if (this.transport == null) {
                throw new IllegalArgumentException("Transport for datadog reporter is null. Please set a valid transport");
            }
            return new DatadogReporter(this.registry, this.transport, this.filter, this.clock, this.host, this.expansions, this.rateUnit, this.durationUnit, this.metricNameFormatter, this.tags, this.prefix, this.tagsCallback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Expansion {
        COUNT("count"),
        RATE_MEAN("meanRate"),
        RATE_1_MINUTE("1MinuteRate"),
        RATE_5_MINUTE("5MinuteRate"),
        RATE_15_MINUTE("15MinuteRate"),
        MIN("min"),
        MEAN("mean"),
        MAX("max"),
        STD_DEV("stddev"),
        MEDIAN("median"),
        P75("p75"),
        P95("p95"),
        P98("p98"),
        P99("p99"),
        P999("p999");

        public static EnumSet<Expansion> ALL;
        private final String displayName;

        private Expansion(String displayName) {
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }

        static {
            ALL = EnumSet.allOf(Expansion.class);
        }
    }
}

