/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket.jetty;

import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.common.AbstractWebSocketTransport;
import org.cometd.server.websocket.jetty.JettyWebSocketTransport;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketEndPoint
extends AbstractWebSocketEndPoint
implements Session.Listener {
    private final Logger _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile Session _wsSession;

    public JettyWebSocketEndPoint(JettyWebSocketTransport transport, BayeuxContext context) {
        super((AbstractWebSocketTransport)transport, context);
    }

    public void onWebSocketOpen(Session session) {
        this._wsSession = session;
        session.demand();
    }

    public void onWebSocketText(String data) {
        try {
            this.onMessage(data, Promise.from(v -> this._wsSession.demand(), this::handleFailure));
        }
        catch (Throwable failure) {
            this.handleFailure(failure);
        }
    }

    public void onWebSocketClose(int code, String reason) {
        this.onClose(code, reason);
    }

    public void onWebSocketError(Throwable failure) {
        this.onError(failure);
    }

    protected void send(ServerSession session, String data, final Promise<Void> promise) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Sending {} on {}", (Object)data, (Object)this);
        }
        this._wsSession.sendText(data, new Callback(){

            public void succeed() {
                promise.succeed(null);
            }

            public void fail(Throwable x) {
                promise.fail(x);
            }
        });
    }

    public void close(int code, String reason) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Closing {}/{} on {}", new Object[]{code, reason, this});
        }
        this._wsSession.close(code, reason, Callback.NOOP);
    }

    private void handleFailure(Throwable t) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("", t);
        }
        this.close(1011, t.toString());
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._wsSession);
    }
}

