/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jakarta;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.cometd.server.CometDRequest;
import org.eclipse.jetty.util.IO;

class JakartaCometDRequest
implements CometDRequest {
    private final HttpServletRequest request;
    private JakartaCometDInput input;

    JakartaCometDRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public List<String> getParameterValues(String name) {
        String[] values = this.request.getParameterValues(name);
        return values == null ? List.of() : List.of(values);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public CometDRequest.Input getInput() {
        if (this.input == null) {
            try {
                this.input = new JakartaCometDInput(this.request);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.input;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void addFailureHandler(Consumer<Throwable> handler) {
        this.request.getAsyncContext().addListener((AsyncListener)new FailureListener(handler));
    }

    private static class JakartaCometDInput
    implements CometDRequest.Input,
    ReadListener {
        private static final Runnable READ_READY = () -> {};
        private final ServletInputStream inputStream;
        private final AtomicReference<Runnable> state = new AtomicReference();
        private volatile Throwable failure;

        private JakartaCometDInput(HttpServletRequest request) throws IOException {
            this.inputStream = request.getInputStream();
            if ("POST".equals(request.getMethod())) {
                this.inputStream.setReadListener((ReadListener)this);
            }
        }

        public void demand(Runnable demandCallback) {
            Runnable readReady = this.state.getAndUpdate(existing -> existing == null ? demandCallback : null);
            if (readReady != null) {
                demandCallback.run();
            }
        }

        public CometDRequest.Input.Chunk read() throws IOException {
            if (this.failure != null) {
                throw IO.rethrow((Throwable)this.failure);
            }
            if (this.inputStream.isFinished()) {
                return CometDRequest.Input.Chunk.EOF;
            }
            if (this.inputStream.isReady()) {
                Chunk chunk = new Chunk();
                ByteBuffer byteBuffer = chunk.byteBuffer();
                int read = this.inputStream.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                if (read < 0) {
                    chunk.release();
                    return CometDRequest.Input.Chunk.EOF;
                }
                if (read == 0) {
                    chunk.release();
                    return null;
                }
                byteBuffer.limit(read);
                return chunk;
            }
            return null;
        }

        public void onDataAvailable() {
            Runnable readCallback = this.state.getAndUpdate(existing -> existing == null ? READ_READY : null);
            if (readCallback != null) {
                readCallback.run();
            }
        }

        public void onAllDataRead() {
            this.onDataAvailable();
        }

        public void onError(Throwable failure) {
            this.failure = failure;
            this.onDataAvailable();
        }

        private static class Chunk
        implements CometDRequest.Input.Chunk {
            private final ByteBuffer byteBuffer = ByteBuffer.allocate(512);

            private Chunk() {
            }

            public ByteBuffer byteBuffer() {
                return this.byteBuffer;
            }

            public boolean isLast() {
                return false;
            }

            public void release() {
            }

            public String toString() {
                return "%s@%x[last=%b,%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.isLast(), this.byteBuffer());
            }
        }
    }

    private static class FailureListener
    implements AsyncListener {
        private final Consumer<Throwable> handler;

        private FailureListener(Consumer<Throwable> handler) {
            this.handler = handler;
        }

        public void onComplete(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
        }

        public void onError(AsyncEvent event) {
            this.handler.accept(event.getThrowable());
        }

        public void onStartAsync(AsyncEvent event) {
        }
    }
}

