/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jakarta;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.Promise;
import org.cometd.server.CometDResponse;

class JakartaCometDResponse
implements CometDResponse {
    private final HttpServletResponse response;
    private JakartaCometDOutput output;

    JakartaCometDResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public CometDResponse.Output getOutput() {
        if (this.output == null) {
            try {
                this.output = new JakartaCometDOutput(this.response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.output;
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    private static class JakartaCometDOutput
    implements CometDResponse.Output,
    WriteListener {
        public static final Promise<Void> WRITE_READY = new Promise<Void>(){};
        private final AtomicReference<Promise<Void>> state = new AtomicReference();
        private final ServletOutputStream outputStream;

        private JakartaCometDOutput(HttpServletResponse response) throws IOException {
            this.outputStream = response.getOutputStream();
            this.outputStream.setWriteListener((WriteListener)this);
        }

        public void onWritePossible() {
            Promise<Void> pendingPromise = this.state.getAndUpdate(existing -> existing == null ? WRITE_READY : null);
            if (pendingPromise != null) {
                pendingPromise.succeed(null);
            }
        }

        public void onError(Throwable failure) {
            Promise<Void> pendingPromise = this.state.getAndUpdate(existing -> existing == null ? WRITE_READY : null);
            if (pendingPromise != null) {
                pendingPromise.fail(failure);
            }
        }

        public void write(boolean last, byte[] bytes, Promise<Void> promise) {
            try {
                this.outputStream.write(bytes);
                if (this.outputStream.isReady()) {
                    promise.succeed(null);
                } else {
                    Promise<Void> writeReady = this.state.getAndUpdate(existing -> existing == null ? promise : null);
                    if (writeReady != null) {
                        promise.succeed(null);
                    }
                }
            }
            catch (Throwable x) {
                promise.fail(x);
            }
        }
    }
}

