/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jakarta;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDRequest;
import org.cometd.server.CometDResponse;
import org.cometd.server.HttpException;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.jakarta.JakartaBayeuxContext;
import org.cometd.server.http.jakarta.JakartaCometDRequest;
import org.cometd.server.http.jakarta.JakartaCometDResponse;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometDServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CometDServlet.class);
    private BayeuxServer bayeuxServer;

    public void init() throws ServletException {
        try {
            this.bayeuxServer = (BayeuxServer)this.getServletContext().getAttribute("org.cometd.bayeux");
            boolean export = false;
            if (this.bayeuxServer == null) {
                export = true;
                this.bayeuxServer = this.newBayeuxServer();
                for (String initParamName : Collections.list(this.getInitParameterNames())) {
                    this.bayeuxServer.setOption(initParamName, (Object)this.getInitParameter(initParamName));
                }
            }
            this.bayeuxServer.setOption(ServletContext.class.getName(), (Object)this.getServletContext());
            LifeCycle.start((Object)this.bayeuxServer);
            if (export) {
                this.getServletContext().setAttribute("org.cometd.bayeux", (Object)this.bayeuxServer);
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    public BayeuxServer getBayeuxServer() {
        return this.bayeuxServer;
    }

    protected BayeuxServer newBayeuxServer() {
        return new BayeuxServerImpl();
    }

    protected void service(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        if ("OPTIONS".equals(request.getMethod())) {
            this.serviceOptions(request, response);
            return;
        }
        final AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        JakartaCometDRequest cometDRequest = new JakartaCometDRequest(request);
        JakartaCometDResponse cometDResponse = new JakartaCometDResponse(response);
        JakartaBayeuxContext bayeuxContext = new JakartaBayeuxContext(request);
        Promise<Void> promise = new Promise<Void>(){

            public void succeed(Void result) {
                asyncContext.complete();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling successful");
                }
            }

            public void fail(Throwable failure) {
                int n;
                if (failure instanceof HttpException) {
                    HttpException http = (HttpException)failure;
                    n = http.getCode();
                } else {
                    n = 500;
                }
                int code = n;
                CometDServlet.this.sendError(request, response, code, failure);
                asyncContext.complete();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Handling failed", failure);
                }
            }
        };
        AbstractHttpTransport transport = AbstractHttpTransport.find((BayeuxServer)this.bayeuxServer, (CometDRequest)cometDRequest);
        if (transport == null) {
            response.sendError(400, "Unknown Bayeux Transport");
        } else {
            transport.handle((BayeuxContext)bayeuxContext, (CometDRequest)cometDRequest, (CometDResponse)cometDResponse, (Promise)promise);
        }
    }

    protected void serviceOptions(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, int code, Throwable failure) {
        block2: {
            try {
                request.setAttribute("jakarta.servlet.error.exception", (Object)failure);
                response.sendError(code);
            }
            catch (Throwable x) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("", x);
            }
        }
    }

    public void destroy() {
        for (ServerSession session : this.bayeuxServer.getSessions()) {
            ((ServerSessionImpl)session).destroyScheduler();
        }
        try {
            LifeCycle.stop((Object)this.bayeuxServer);
        }
        catch (Exception x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("", (Throwable)x);
            }
        }
        finally {
            this.bayeuxServer = null;
            this.getServletContext().removeAttribute("org.cometd.bayeux");
        }
    }
}

