/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.CometDRequest;
import org.cometd.server.CometDResponse;
import org.cometd.server.HttpException;
import org.cometd.server.http.AbstractHttpTransport;
import org.cometd.server.http.JSONHttpTransport;
import org.cometd.server.http.TransportContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPHttpTransport
extends AbstractHttpTransport {
    public static final String NAME = "callback-polling";
    public static final String CALLBACK_PARAMETER_OPTION = "callbackParameter";
    public static final String CALLBACK_PARAMETER_MAX_LENGTH_OPTION = "callbackParameterMaxLength";
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONHttpTransport.class);
    private static final String PREFIX = "long-polling.jsonp";
    private static final Pattern CALLBACK_PATTERN = Pattern.compile("^[a-zA-Z0-9._\\-]+$");
    private static final byte[] MESSAGE_BEGIN = new byte[]{40, 91};
    private static final byte[] MESSAGE_END = new byte[]{93, 41};
    private String callbackParam = "jsonp";
    private int callbackMaxLength = 64;

    public JSONPHttpTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public void init() {
        super.init();
        this.callbackParam = this.getOption(CALLBACK_PARAMETER_OPTION, this.callbackParam);
        this.callbackMaxLength = this.getOption(CALLBACK_PARAMETER_MAX_LENGTH_OPTION, this.callbackMaxLength);
        this.setMetaConnectDeliveryOnly(true);
    }

    public String getCallbackParameter() {
        return this.callbackParam;
    }

    public int getCallbackMaxLength() {
        return this.callbackMaxLength;
    }

    @Override
    public boolean accept(CometDRequest request) {
        List<String> callbackValue = request.getParameterValues(this.getCallbackParameter());
        return "GET".equals(request.getMethod()) && this.isCallbackValueValid(callbackValue);
    }

    private boolean isCallbackValueValid(List<String> callbackValues) {
        if (callbackValues.size() != 1) {
            return false;
        }
        String callbackValue = callbackValues.get(0);
        return callbackValue.length() <= this.getCallbackMaxLength() && CALLBACK_PATTERN.matcher(callbackValue).matches();
    }

    @Override
    protected void handle(TransportContext context) {
        try {
            List<Object> messages;
            List<String> requestParameters = context.request().getParameterValues("message");
            if (requestParameters.isEmpty()) {
                throw new IOException("Missing 'message' request parameter");
            }
            if (requestParameters.size() == 1) {
                List<ServerMessage.Mutable> parsed = this.parseMessages(requestParameters.get(0));
                messages = parsed == null ? List.of() : parsed;
            } else {
                messages = new ArrayList();
                for (String batch : requestParameters) {
                    List<ServerMessage.Mutable> parsed;
                    if (batch == null || (parsed = this.parseMessages(batch)) == null) continue;
                    messages.addAll(parsed);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parsed {} messages", (Object)messages.size());
            }
            this.processMessages(context, messages);
        }
        catch (ParseException x) {
            LOGGER.warn("Could not parse JSON: " + x.getMessage(), (Object)x.getMessage());
            context.promise().fail((Throwable)new HttpException(400, x.getCause()));
        }
        catch (Throwable x) {
            context.promise().fail(x);
        }
    }

    @Override
    protected void writePrepare(TransportContext context, Promise<Void> promise) {
        CometDResponse response = context.response();
        response.setContentType("text/javascript;charset=UTF-8");
        String callback = context.request().getParameterValues(this.getCallbackParameter()).get(0);
        response.getOutput().write(false, callback.getBytes(StandardCharsets.UTF_8), promise);
    }

    @Override
    protected void writeBegin(CometDResponse.Output output, Promise<Void> promise) {
        output.write(false, MESSAGE_BEGIN, promise);
    }

    @Override
    protected void writeEnd(CometDResponse.Output output, Promise<Void> promise) {
        output.write(true, MESSAGE_END, promise);
    }
}

