/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.List;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;

public abstract class JacksonJSONContext<M extends Message.Mutable, I extends M> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final CollectionType collectionType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, this.messageClass());

    protected JacksonJSONContext() {
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected abstract Class<I> messageClass();

    public List<M> parse(String json) throws ParseException {
        try {
            return (List)this.getObjectMapper().readValue(json, (JavaType)this.collectionType);
        }
        catch (IOException x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    public JSONContext.AsyncParser newAsyncParser() {
        try {
            JsonParser jsonParser = this.objectMapper.getFactory().createNonBlockingByteArrayParser();
            return new AsyncJsonParser(jsonParser);
        }
        catch (Throwable x) {
            return null;
        }
    }

    public String generate(M message) {
        try {
            return this.getObjectMapper().writeValueAsString(message);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public JSONContext.Parser getParser() {
        return new ObjectMapperParser();
    }

    public JSONContext.Generator getGenerator() {
        return new ObjectMapperGenerator();
    }

    private class AsyncJsonParser
    implements JSONContext.AsyncParser {
        private final JsonParser jsonParser;
        private final TokenBuffer tokenBuffer;

        public AsyncJsonParser(JsonParser jsonParser) {
            this.jsonParser = jsonParser;
            this.tokenBuffer = new TokenBuffer(jsonParser);
        }

        @Override
        public void parse(ByteBuffer buffer) {
            block6: {
                try {
                    NonBlockingInputFeeder input = this.jsonParser.getNonBlockingInputFeeder();
                    if (input instanceof ByteBufferFeeder) {
                        ByteBufferFeeder feeder = (ByteBufferFeeder)input;
                        feeder.feedInput(buffer);
                        this.parseInput();
                        break block6;
                    }
                    if (input instanceof ByteArrayFeeder) {
                        ByteArrayFeeder feeder = (ByteArrayFeeder)input;
                        if (buffer.hasArray()) {
                            int startIndex = buffer.arrayOffset() + buffer.position();
                            int endIndex = startIndex + buffer.remaining();
                            feeder.feedInput(buffer.array(), startIndex, endIndex);
                        } else {
                            byte[] bytes = new byte[buffer.remaining()];
                            buffer.get(bytes);
                            feeder.feedInput(bytes, 0, bytes.length);
                        }
                        this.parseInput();
                        break block6;
                    }
                    throw new UnsupportedOperationException();
                }
                catch (IOException x) {
                    throw new IllegalStateException(x);
                }
            }
        }

        private void parseInput() throws IOException {
            JsonToken jsonToken;
            while ((jsonToken = this.jsonParser.nextToken()) != JsonToken.NOT_AVAILABLE) {
                this.tokenBuffer.copyCurrentEvent(this.jsonParser);
            }
        }

        @Override
        public <R> R complete() {
            try {
                NonBlockingInputFeeder feeder = this.jsonParser.getNonBlockingInputFeeder();
                feeder.endOfInput();
                this.jsonParser.nextToken();
                return (R)JacksonJSONContext.this.objectMapper.readValue(this.tokenBuffer.asParser(), (JavaType)JacksonJSONContext.this.collectionType);
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x);
            }
        }
    }

    private class ObjectMapperParser
    implements JSONContext.Parser {
        private ObjectMapperParser() {
        }

        @Override
        public <R> R parse(Reader reader, Class<R> type) throws ParseException {
            try {
                return (R)JacksonJSONContext.this.getObjectMapper().readValue(reader, type);
            }
            catch (IOException x) {
                throw (ParseException)new ParseException("", -1).initCause(x);
            }
        }
    }

    protected class ObjectMapperGenerator
    implements JSONContext.Generator {
        protected ObjectMapperGenerator() {
        }

        @Override
        public String generate(Object object) {
            try {
                return JacksonJSONContext.this.getObjectMapper().writeValueAsString(object);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

