/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.transport;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.cometd.client.transport.ClientTransport;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpCookieStore;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.SetCookieParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientTransport
extends ClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientTransport.class);
    private final SetCookieParser cookieParser = SetCookieParser.newInstance();
    private volatile HttpCookieStore cookieStore;

    @Deprecated
    protected HttpClientTransport(String name, String url, Map<String, Object> options) {
        this(name, url, options, null);
    }

    protected HttpClientTransport(String name, String url, Map<String, Object> options, ScheduledExecutorService scheduler) {
        super(name, url, options, scheduler);
    }

    protected HttpCookieStore getHttpCookieStore() {
        return this.cookieStore;
    }

    public void setHttpCookieStore(HttpCookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    protected List<HttpCookie> getCookies(URI uri) {
        return this.getHttpCookieStore().match(uri);
    }

    protected void storeCookies(URI uri, Map<String, List<String>> headers) {
        headers.forEach((key, values) -> {
            if (HttpHeader.SET_COOKIE.is(key)) {
                values.forEach(value -> {
                    HttpCookie cookie = this.cookieParser.parse(value);
                    if (cookie != null) {
                        this.cookieStore.add(uri, cookie);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Stored cookie {}", (Object)cookie);
                        }
                    }
                });
            }
        });
    }
}

