/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import jcifs.CIFSUnsupportedCryptoException;
import jcifs.util.HMACT64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class Crypto {
    private static Provider provider = null;

    private Crypto() {
    }

    public static MessageDigest getMD4() {
        try {
            return MessageDigest.getInstance("MD4", Crypto.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CIFSUnsupportedCryptoException(e);
        }
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CIFSUnsupportedCryptoException(e);
        }
    }

    public static MessageDigest getSHA512() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CIFSUnsupportedCryptoException(e);
        }
    }

    public static MessageDigest getHMACT64(byte[] key) {
        return new HMACT64(key);
    }

    public static Cipher getArcfour(byte[] key) {
        try {
            Cipher c = Cipher.getInstance("RC4");
            c.init(1, new SecretKeySpec(key, "RC4"));
            return c;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CIFSUnsupportedCryptoException(e);
        }
    }

    public static Cipher getDES(byte[] key) {
        if (key.length == 7) {
            return Crypto.getDES(Crypto.des7to8(key));
        }
        try {
            Cipher c = Cipher.getInstance("DES/ECB/NoPadding");
            c.init(1, new SecretKeySpec(key, "DES"));
            return c;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CIFSUnsupportedCryptoException(e);
        }
    }

    static byte[] des7to8(byte[] key) {
        byte[] key8 = new byte[]{(byte)(key[0] & 0xFE), (byte)(key[0] << 7 | (key[1] & 0xFF) >>> 1), (byte)(key[1] << 6 | (key[2] & 0xFF) >>> 2), (byte)(key[2] << 5 | (key[3] & 0xFF) >>> 3), (byte)(key[3] << 4 | (key[4] & 0xFF) >>> 4), (byte)(key[4] << 3 | (key[5] & 0xFF) >>> 5), (byte)(key[5] << 2 | (key[6] & 0xFF) >>> 6), (byte)(key[6] << 1)};
        for (int i = 0; i < key8.length; ++i) {
            int n = i;
            key8[n] = (byte)(key8[n] ^ Integer.bitCount(key8[i] ^ 1) & 1);
        }
        return key8;
    }

    public static Provider getProvider() {
        if (provider != null) {
            return provider;
        }
        provider = new BouncyCastleProvider();
        return provider;
    }

    public static void initProvider(Provider customProvider) throws CIFSUnsupportedCryptoException {
        if (provider != null) {
            throw new CIFSUnsupportedCryptoException("Provider can't be re-initialized. Provider has already been initialized with " + provider.getInfo());
        }
        provider = customProvider;
    }
}

