/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.io;

import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.smb2.RequestWithFileId;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.io.Smb2FlushResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2FlushRequest
extends ServerMessageBlock2Request<Smb2FlushResponse>
implements RequestWithFileId {
    private byte[] fileId;

    public Smb2FlushRequest(Configuration config, byte[] fileId) {
        super(config, 7);
        this.fileId = fileId;
    }

    @Override
    protected Smb2FlushResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2FlushResponse> req) {
        return new Smb2FlushResponse(tc.getConfig());
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    @Override
    public int size() {
        return Smb2FlushRequest.size8(88);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(24L, dst, dstIndex);
        dstIndex += 2;
        dstIndex += 2;
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        return (dstIndex += 16) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

