/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jcifs.CIFSContext;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type2Message
extends NtlmMessage {
    private static final Logger log = LoggerFactory.getLogger(Type2Message.class);
    private byte[] challenge;
    private String target;
    private byte[] context;
    private byte[] targetInformation;
    private static final Map<String, byte[]> TARGET_INFO_CACHE = new HashMap<String, byte[]>();

    private static byte[] getDefaultTargetInfo(CIFSContext tc) {
        String domain = tc.getConfig().getDefaultDomain();
        byte[] ti = TARGET_INFO_CACHE.get(domain);
        if (ti != null) {
            return ti;
        }
        ti = Type2Message.makeTargetInfo(tc, domain);
        TARGET_INFO_CACHE.put(domain, ti);
        return ti;
    }

    private static byte[] makeTargetInfo(CIFSContext tc, String domainStr) {
        byte[] domain = new byte[]{};
        if (domainStr != null) {
            try {
                domain = domainStr.getBytes("UTF-16LE");
            }
            catch (IOException ex) {
                log.debug("Failed to get domain bytes", (Throwable)ex);
            }
        }
        int domainLength = domain.length;
        byte[] server = new byte[]{};
        String host = tc.getNameServiceClient().getLocalHost().getHostName();
        if (host != null) {
            try {
                server = host.getBytes("UTF-16LE");
            }
            catch (IOException ex) {
                log.debug("Failed to get host bytes", (Throwable)ex);
            }
        }
        int serverLength = server.length;
        byte[] targetInfo = new byte[(domainLength > 0 ? domainLength + 4 : 0) + (serverLength > 0 ? serverLength + 4 : 0) + 4];
        int offset = 0;
        if (domainLength > 0) {
            Type2Message.writeUShort(targetInfo, offset, 2);
            Type2Message.writeUShort(targetInfo, offset += 2, domainLength);
            System.arraycopy(domain, 0, targetInfo, offset += 2, domainLength);
            offset += domainLength;
        }
        if (serverLength > 0) {
            Type2Message.writeUShort(targetInfo, offset, 1);
            Type2Message.writeUShort(targetInfo, offset += 2, serverLength);
            System.arraycopy(server, 0, targetInfo, offset += 2, serverLength);
        }
        return targetInfo;
    }

    public Type2Message(CIFSContext tc) {
        this(tc, Type2Message.getDefaultFlags(tc), null, null);
    }

    public Type2Message(CIFSContext tc, Type1Message type1) {
        this(tc, type1, null, null);
    }

    public Type2Message(CIFSContext tc, Type1Message type1, byte[] challenge, String target) {
        this(tc, Type2Message.getDefaultFlags(tc, type1), challenge, type1 != null && target == null && type1.getFlag(4) ? tc.getConfig().getDefaultDomain() : target);
    }

    public Type2Message(CIFSContext tc, int flags, byte[] challenge, String target) {
        this.setFlags(flags);
        this.setChallenge(challenge);
        this.setTarget(target);
        if (target != null) {
            this.setTargetInformation(Type2Message.getDefaultTargetInfo(tc));
        }
    }

    public Type2Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public static int getDefaultFlags(CIFSContext tc) {
        return 0x2000200 | (tc.getConfig().isUseUnicode() ? 1 : 2);
    }

    public static int getDefaultFlags(CIFSContext tc, Type1Message type1) {
        String domain;
        if (type1 == null) {
            return Type2Message.getDefaultFlags(tc);
        }
        int flags = 0x2000200;
        int type1Flags = type1.getFlags();
        flags |= (type1Flags & 1) != 0 ? 1 : 2;
        if ((type1Flags & 4) != 0 && (domain = tc.getConfig().getDefaultDomain()) != null) {
            flags |= 0x10004;
        }
        return flags;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public byte[] getTargetInformation() {
        return this.targetInformation;
    }

    public void setTargetInformation(byte[] targetInformation) {
        this.targetInformation = targetInformation;
    }

    public byte[] getContext() {
        return this.context;
    }

    public void setContext(byte[] context) {
        this.context = context;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        int size = 48;
        int flags = this.getFlags();
        String targetName = this.getTarget();
        byte[] targetInformationBytes = this.getTargetInformation();
        byte[] targetBytes = new byte[]{};
        if (this.getFlag(4)) {
            if (targetName != null && targetName.length() != 0) {
                targetBytes = (flags & 1) != 0 ? targetName.getBytes("UTF-16LE") : targetName.toUpperCase().getBytes(Type2Message.getOEMEncoding());
                size += targetBytes.length;
            } else {
                flags &= 0xFFFFFFFB;
            }
        }
        if (targetInformationBytes != null) {
            size += targetInformationBytes.length;
            flags |= 0x800000;
        }
        if (this.getFlag(0x2000000)) {
            size += 8;
        }
        byte[] type2 = new byte[size];
        int pos = 0;
        System.arraycopy(NTLMSSP_SIGNATURE, 0, type2, pos, NTLMSSP_SIGNATURE.length);
        Type2Message.writeULong(type2, pos += NTLMSSP_SIGNATURE.length, 2);
        int targetNameOff = Type2Message.writeSecurityBuffer(type2, pos += 4, targetBytes);
        Type2Message.writeULong(type2, pos += 8, flags);
        byte[] challengeBytes = this.getChallenge();
        System.arraycopy(challengeBytes != null ? challengeBytes : new byte[8], 0, type2, pos += 4, 8);
        byte[] contextBytes = this.getContext();
        System.arraycopy(contextBytes != null ? contextBytes : new byte[8], 0, type2, pos += 8, 8);
        int targetInfoOff = Type2Message.writeSecurityBuffer(type2, pos += 8, targetInformationBytes);
        pos += 8;
        if (this.getFlag(0x2000000)) {
            System.arraycopy(NTLMSSP_VERSION, 0, type2, pos, NTLMSSP_VERSION.length);
            pos += NTLMSSP_VERSION.length;
        }
        pos += Type2Message.writeSecurityBufferContent(type2, pos, targetNameOff, targetBytes);
        pos += Type2Message.writeSecurityBufferContent(type2, pos, targetInfoOff, targetInformationBytes);
        return type2;
    }

    public String toString() {
        String targetString = this.getTarget();
        byte[] challengeBytes = this.getChallenge();
        byte[] contextBytes = this.getContext();
        byte[] targetInformationBytes = this.getTargetInformation();
        return "Type2Message[target=" + targetString + ",challenge=" + (challengeBytes == null ? "null" : "<" + challengeBytes.length + " bytes>") + ",context=" + (contextBytes == null ? "null" : "<" + contextBytes.length + " bytes>") + ",targetInformation=" + (targetInformationBytes == null ? "null" : "<" + targetInformationBytes.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    private void parse(byte[] input) throws IOException {
        int pos = 0;
        for (int i = 0; i < 8; ++i) {
            if (input[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type2Message.readULong(input, pos += 8) != 2) {
            throw new IOException("Not a Type 2 message.");
        }
        int flags = Type2Message.readULong(input, (pos += 4) + 8);
        this.setFlags(flags);
        byte[] targetName = Type2Message.readSecurityBuffer(input, pos);
        int targetNameOff = Type2Message.readULong(input, pos + 4);
        if (targetName.length != 0) {
            this.setTarget(new String(targetName, (flags & 1) != 0 ? "UTF-16LE" : Type2Message.getOEMEncoding()));
        }
        if (!Type2Message.allZeros8(input, pos += 12)) {
            byte[] challengeBytes = new byte[8];
            System.arraycopy(input, pos, challengeBytes, 0, challengeBytes.length);
            this.setChallenge(challengeBytes);
        }
        if (targetNameOff < (pos += 8) + 8 || input.length < pos + 8) {
            return;
        }
        if (!Type2Message.allZeros8(input, pos)) {
            byte[] contextBytes = new byte[8];
            System.arraycopy(input, pos, contextBytes, 0, contextBytes.length);
            this.setContext(contextBytes);
        }
        if (targetNameOff < (pos += 8) + 8 || input.length < pos + 8) {
            return;
        }
        byte[] targetInfo = Type2Message.readSecurityBuffer(input, pos);
        if (targetInfo.length != 0) {
            this.setTargetInformation(targetInfo);
        }
    }

    private static boolean allZeros8(byte[] input, int pos) {
        for (int i = pos; i < pos + 8; ++i) {
            if (input[i] == 0) continue;
            return false;
        }
        return true;
    }
}

