/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;

public abstract class ANode {
    final Location location;

    ANode(Location location) {
        this.location = Objects.requireNonNull(location);
    }

    abstract void extractVariables(Set<String> var1);

    abstract void analyze(Locals var1);

    abstract void write(MethodWriter var1, Globals var2);

    RuntimeException createError(RuntimeException exception) {
        return this.location.createError(exception);
    }

    public abstract String toString();

    protected String singleLineToString(Object ... subs) {
        return this.singleLineToString(Arrays.asList(subs));
    }

    protected String singleLineToString(Collection<? extends Object> subs) {
        return this.joinWithName(this.getClass().getSimpleName(), subs, Collections.emptyList());
    }

    protected String singleLineToStringWithOptionalArgs(Collection<? extends ANode> arguments, Object ... restOfSubs) {
        ArrayList<String> subs = new ArrayList<String>();
        Collections.addAll(subs, restOfSubs);
        if (!arguments.isEmpty()) {
            subs.add(this.joinWithName("Args", arguments, Collections.emptyList()));
        }
        return this.singleLineToString(subs);
    }

    protected String multilineToString(Collection<? extends Object> sameLine, Collection<? extends Object> ownLine) {
        return this.joinWithName(this.getClass().getSimpleName(), sameLine, ownLine);
    }

    protected List<String> pairwiseToString(Collection<? extends Object> lefts, Collection<? extends Object> rights) {
        ArrayList<String> pairs = new ArrayList<String>(Math.max(lefts.size(), rights.size()));
        Iterator<? extends Object> left = lefts.iterator();
        Iterator<? extends Object> right = rights.iterator();
        while (left.hasNext() || right.hasNext()) {
            pairs.add(this.joinWithName("Pair", Arrays.asList(left.hasNext() ? left.next() : "<uneven>", right.hasNext() ? right.next() : "<uneven>"), Collections.emptyList()));
        }
        return pairs;
    }

    protected String joinWithName(String name, Collection<? extends Object> sameLine, Collection<? extends Object> ownLine) {
        StringBuilder b = new StringBuilder();
        b.append('(').append(name);
        for (Object object : sameLine) {
            b.append(' ').append(object);
        }
        if (ownLine.size() == 1 && sameLine.isEmpty()) {
            b.append(' ').append(ownLine.iterator().next());
        } else {
            for (Object object : ownLine) {
                b.append("\n  ").append(Objects.toString(object).replace("\n", "\n  "));
            }
        }
        return b.append(')').toString();
    }
}

