/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.testing;

import com.google.inject.Module;
import java.io.File;
import java.util.Collections;
import java.util.Optional;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.testing.PlexusTestConfiguration;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class PlexusExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace PLEXUS_EXTENSION = ExtensionContext.Namespace.create((Object[])new Object[]{"PlexusExtension"});
    public static final String BASEDIR_KEY = "basedir";
    private static final ThreadLocal<ExtensionContext> extensionContextThreadLocal = new ThreadLocal();

    public void beforeEach(ExtensionContext context) throws Exception {
        this.setTestBasedir(PlexusExtension.getDefaultBasedir(), context);
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> ((DefaultPlexusContainer)this.getContainer(context)).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> binder.requestInjection(testInstance)}));
    }

    private PlexusContainer setupContainer(ExtensionContext context) {
        DefaultPlexusContainer container;
        extensionContextThreadLocal.set(context);
        context.getStore(PLEXUS_EXTENSION).put((Object)"threadLocalCloseable", extensionContextThreadLocal::remove);
        DefaultContext plexusContext = new DefaultContext();
        plexusContext.put((Object)BASEDIR_KEY, (Object)this.getTestBasedir(context));
        this.customizeContext((Context)plexusContext);
        boolean hasPlexusHome = plexusContext.contains((Object)"plexus.home");
        if (!hasPlexusHome) {
            File f = new File(this.getTestBasedir(context), "target/plexus-home");
            if (!f.isDirectory()) {
                f.mkdir();
            }
            plexusContext.put((Object)"plexus.home", (Object)f.getAbsolutePath());
        }
        String config = this.getCustomConfigurationName();
        ContainerConfiguration containerConfiguration = new DefaultContainerConfiguration().setName("test").setContext(plexusContext.getContextData());
        if (config != null) {
            containerConfiguration.setContainerConfiguration(config);
        } else {
            String resource = this.getConfigurationName(context);
            containerConfiguration.setContainerConfiguration(resource);
        }
        this.customizeContainerConfiguration(containerConfiguration);
        this.testInstanceCustomizeContainerConfiguration(containerConfiguration, context);
        try {
            container = new DefaultPlexusContainer(containerConfiguration);
            container.addComponent((Object)container, PlexusContainer.class.getName());
        }
        catch (PlexusContainerException e) {
            throw new IllegalArgumentException("Failed to create plexus container.", e);
        }
        this.testInstanceCustomizeContainer((PlexusContainer)container, context);
        context.getStore(PLEXUS_EXTENSION).put(PlexusClosableWrapper.class, (Object)new PlexusClosableWrapper((PlexusContainer)container));
        return container;
    }

    protected void customizeContainerConfiguration(ContainerConfiguration containerConfiguration) {
        containerConfiguration.setAutoWiring(true);
        containerConfiguration.setClassPathScanning("index");
    }

    private void testInstanceCustomizeContainerConfiguration(ContainerConfiguration containerConfiguration, ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> {
            if (testInstance instanceof PlexusTestConfiguration) {
                ((PlexusTestConfiguration)testInstance).customizeConfiguration(containerConfiguration);
            }
        });
    }

    private void testInstanceCustomizeContainer(PlexusContainer container, ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> {
            if (testInstance instanceof PlexusTestConfiguration) {
                ((PlexusTestConfiguration)testInstance).customizeContainer(container);
            }
        });
    }

    protected void customizeContext(Context context) {
    }

    public void afterEach(ExtensionContext context) throws Exception {
    }

    protected String getTestBasedir(ExtensionContext context) {
        String testBasedir = (String)context.getStore(PLEXUS_EXTENSION).get((Object)BASEDIR_KEY, String.class);
        if (testBasedir == null) {
            testBasedir = PlexusExtension.getDefaultBasedir();
            context.getStore(PLEXUS_EXTENSION).put((Object)BASEDIR_KEY, (Object)testBasedir);
        }
        return testBasedir;
    }

    protected void setTestBasedir(String testBasedir, ExtensionContext context) {
        context.getStore(PLEXUS_EXTENSION).put((Object)BASEDIR_KEY, (Object)testBasedir);
    }

    public PlexusContainer getContainer(ExtensionContext context) {
        PlexusClosableWrapper container = (PlexusClosableWrapper)context.getStore(PLEXUS_EXTENSION).get(PlexusClosableWrapper.class, PlexusClosableWrapper.class);
        if (container == null) {
            return this.setupContainer(context);
        }
        return container.get();
    }

    protected String getCustomConfigurationName() {
        return null;
    }

    protected String getConfigurationName(ExtensionContext context) {
        Class testClass;
        for (Class clazz = testClass = context.getRequiredTestClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String name = clazz.getName().replace('.', '/') + ".xml";
            if (testClass.getClassLoader().getResource(name) == null) continue;
            return name;
        }
        return null;
    }

    public static File getTestFile(String path) {
        return new File(PlexusExtension.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = PlexusExtension.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return PlexusExtension.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return PlexusExtension.getTestFile(basedir, path).getAbsolutePath();
    }

    private static String getDefaultBasedir() {
        String basedir = System.getProperty(BASEDIR_KEY);
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }

    public static String getBasedir() {
        return Optional.ofNullable(extensionContextThreadLocal.get()).map(ec -> (String)ec.getStore(PLEXUS_EXTENSION).get((Object)BASEDIR_KEY, String.class)).orElseGet(PlexusExtension::getDefaultBasedir);
    }

    public static String getTestConfiguration(Class<?> clazz) {
        String s = clazz.getName().replace('.', '/');
        return s.substring(0, s.indexOf("$")) + ".xml";
    }

    static {
        if (System.getProperty("guice_custom_class_loading", "").trim().isEmpty()) {
            System.setProperty("guice_custom_class_loading", "CHILD");
        }
    }

    private static class PlexusClosableWrapper
    implements AutoCloseable {
        private final PlexusContainer container;

        PlexusClosableWrapper(PlexusContainer container) {
            this.container = container;
        }

        @Override
        public void close() {
            this.container.dispose();
        }

        public PlexusContainer get() {
            return this.container;
        }
    }
}

