/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.mailsender;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSender;
import org.codehaus.plexus.mailsender.MailSenderException;

public abstract class AbstractMailSender
extends AbstractLogEnabled
implements MailSender {
    public static final int DEFAULT_SMTP_PORT = 25;
    private String smtpHost;
    private int smtpPort;
    private String username;
    private String password;
    private boolean sslMode;
    private boolean tlsEnabled;
    private boolean debugMode;

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String host) {
        this.smtpHost = host;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int port) {
        this.smtpPort = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public boolean isSslMode() {
        return this.sslMode;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setSslMode(boolean sslEnabled) {
        this.setSslMode(sslEnabled, false);
    }

    public void setSslMode(boolean sslEnabled, boolean tlsEnabled) {
        this.sslMode = sslEnabled;
        this.tlsEnabled = tlsEnabled;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void send(String subject, String content, String toMailbox, String toName, String fromMailbox, String fromName) throws MailSenderException {
        this.send(subject, content, toMailbox, toName, fromMailbox, fromName, new HashMap());
    }

    public void send(String subject, String content, String toMailbox, String toName, String fromMailbox, String fromName, Map headers) throws MailSenderException {
        MailMessage message = new MailMessage();
        message.setSubject(subject);
        message.setContent(content);
        message.setFrom(fromMailbox, fromName);
        message.addTo(toMailbox, toName);
        Iterator iter = headers.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object header = headers.get(key);
            if (header instanceof List) {
                Iterator headerVals = ((List)header).iterator();
                while (iter.hasNext()) {
                    message.addHeader(key, (String)headerVals.next());
                }
                continue;
            }
            message.addHeader(key, (String)headers.get(key));
        }
        this.send(message);
    }

    public void verify(MailMessage message) throws MailSenderException {
        MailMessage.Address from = message.getFrom();
        if (from.getMailbox() == null) {
            throw new MailSenderException("From mailbox isn't set.");
        }
        if (message.getToAddresses().size() == 0 && message.getCcAddresses().size() == 0 && message.getBccAddresses().size() == 0) {
            throw new MailSenderException("The mail requires at least one recipient.");
        }
    }
}

