/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.i18n.I18NTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultI18N
implements I18N {
    private final Logger log = LoggerFactory.getLogger(DefaultI18N.class);
    private static final Object[] NO_ARGS = new Object[0];
    private Map<String, Map<Locale, ResourceBundle>> bundles;
    private String[] bundleNames;
    private String defaultBundleName;
    private boolean devMode;

    public DefaultI18N() {
        this.initialize();
    }

    public DefaultI18N(String[] bundleNames) {
        this.bundleNames = bundleNames != null ? (String[])bundleNames.clone() : new String[]{};
        this.initialize();
    }

    @Override
    public String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }

    @Override
    public String getDefaultCountry() {
        return Locale.getDefault().getCountry();
    }

    @Override
    public String getDefaultBundleName() {
        return this.defaultBundleName;
    }

    @Override
    public String[] getBundleNames() {
        return (String[])this.bundleNames.clone();
    }

    @Override
    public ResourceBundle getBundle() {
        return this.getBundle(this.getDefaultBundleName(), (Locale)null);
    }

    @Override
    public ResourceBundle getBundle(String bundleName) {
        return this.getBundle(bundleName, (Locale)null);
    }

    @Override
    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    @Override
    public ResourceBundle getBundle(String bundleName, Locale locale) {
        ResourceBundle rb;
        Map<Locale, ResourceBundle> bundlesByLocale;
        String string = bundleName = bundleName == null ? this.getDefaultBundleName() : bundleName.trim();
        if (this.devMode) {
            ResourceBundle.clearCache();
        }
        if (locale == null) {
            locale = this.getLocale(null);
        }
        if ((bundlesByLocale = this.bundles.get(bundleName)) != null) {
            rb = bundlesByLocale.get(locale);
            if (rb == null) {
                rb = this.cacheBundle(bundleName, locale);
            }
        } else {
            rb = this.cacheBundle(bundleName, locale);
        }
        return rb;
    }

    @Override
    public Locale getLocale(String header) {
        I18NTokenizer tok;
        if (header != null && !header.isEmpty() && (tok = new I18NTokenizer(header)).hasNext()) {
            return tok.next();
        }
        return Locale.getDefault();
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, Locale locale) {
        return this.getString(this.getDefaultBundleName(), locale, key);
    }

    @Override
    public String getString(String bundleName, Locale locale, String key) {
        ResourceBundle rb;
        String value;
        if (locale == null) {
            locale = this.getLocale(null);
        }
        if ((value = this.getStringOrNull(rb = this.getBundle(bundleName, locale), key)) == null) {
            for (String name : this.bundleNames) {
                if (name.equals(bundleName) || (value = this.getStringOrNull(rb = this.getBundle(name, locale), key)) == null) continue;
                locale = rb.getLocale();
                break;
            }
        }
        if (value == null) {
            this.log.debug("Noticed missing resource: bundleName={}, locale={}, key={}", new Object[]{bundleName, locale, key});
            value = key;
        }
        return value;
    }

    @Override
    public String format(String key, Object arg1) {
        return this.format(this.defaultBundleName, Locale.getDefault(), key, new Object[]{arg1});
    }

    @Override
    public String format(String key, Object arg1, Object arg2) {
        return this.format(this.defaultBundleName, Locale.getDefault(), key, new Object[]{arg1, arg2});
    }

    @Override
    public String format(String bundleName, Locale locale, String key, Object arg1) {
        return this.format(bundleName, locale, key, new Object[]{arg1});
    }

    @Override
    public String format(String bundleName, Locale locale, String key, Object arg1, Object arg2) {
        return this.format(bundleName, locale, key, new Object[]{arg1, arg2});
    }

    @Override
    public String format(String bundleName, Locale locale, String key, Object[] args) {
        if (locale == null) {
            locale = this.getLocale(null);
        }
        String value = this.getString(bundleName, locale, key);
        if (args == null) {
            args = NO_ARGS;
        }
        return new MessageFormat(value, locale).format(args);
    }

    public void initialize() {
        this.bundles = new HashMap<String, Map<Locale, ResourceBundle>>();
        this.initializeBundleNames();
        if ("true".equals(System.getProperty("PLEXUS_DEV_MODE"))) {
            this.devMode = true;
        }
    }

    protected void initializeBundleNames() {
        if (this.defaultBundleName != null && !this.defaultBundleName.isEmpty()) {
            if (this.bundleNames == null || this.bundleNames.length <= 0) {
                this.bundleNames = new String[]{this.defaultBundleName};
            } else {
                String[] array = new String[this.bundleNames.length + 1];
                array[0] = this.defaultBundleName;
                System.arraycopy(this.bundleNames, 0, array, 1, this.bundleNames.length);
                this.bundleNames = array;
            }
        }
        if (this.bundleNames == null) {
            this.bundleNames = new String[0];
        }
    }

    private synchronized ResourceBundle cacheBundle(String bundleName, Locale locale) throws MissingResourceException {
        ResourceBundle rb;
        Map<Locale, ResourceBundle> bundlesByLocale = this.bundles.get(bundleName);
        ResourceBundle resourceBundle = rb = bundlesByLocale == null ? null : bundlesByLocale.get(locale);
        if (rb == null) {
            block4: {
                bundlesByLocale = bundlesByLocale == null ? new HashMap<Locale, ResourceBundle>(3) : new HashMap<Locale, ResourceBundle>(bundlesByLocale);
                try {
                    rb = ResourceBundle.getBundle(bundleName, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
                }
                catch (MissingResourceException e) {
                    rb = this.findBundleByLocale(bundleName, locale, bundlesByLocale);
                    if (rb != null) break block4;
                    throw (MissingResourceException)e.fillInStackTrace();
                }
            }
            if (rb != null) {
                bundlesByLocale.put(rb.getLocale(), rb);
                HashMap<String, Map<Locale, ResourceBundle>> bundlesByName = new HashMap<String, Map<Locale, ResourceBundle>>(this.bundles);
                bundlesByName.put(bundleName, bundlesByLocale);
                this.bundles = bundlesByName;
            }
        }
        return rb;
    }

    private ResourceBundle findBundleByLocale(String bundleName, Locale locale, Map<Locale, ResourceBundle> bundlesByLocale) {
        Locale withDefaultLanguage;
        ResourceBundle rb = null;
        if (locale.getCountry() != null && !locale.getCountry().isEmpty() && Locale.getDefault().getLanguage().equals(locale.getLanguage())) {
            Locale withDefaultCountry = new Locale(locale.getLanguage(), Locale.getDefault().getCountry());
            rb = bundlesByLocale.get(withDefaultCountry);
            if (rb == null) {
                rb = this.getBundleIgnoreException(bundleName, withDefaultCountry);
            }
        } else if (locale.getLanguage() != null && !locale.getLanguage().isEmpty() && Locale.getDefault().getCountry().equals(locale.getCountry()) && (rb = bundlesByLocale.get(withDefaultLanguage = new Locale(Locale.getDefault().getLanguage(), locale.getCountry()))) == null) {
            rb = this.getBundleIgnoreException(bundleName, withDefaultLanguage);
        }
        if (rb == null && !Locale.getDefault().equals(locale)) {
            rb = this.getBundleIgnoreException(bundleName, Locale.getDefault());
        }
        return rb;
    }

    private ResourceBundle getBundleIgnoreException(String bundleName, Locale locale) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT));
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    protected final String getStringOrNull(ResourceBundle rb, String key) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }
}

