/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class I18NTokenizer
implements Iterator<Locale> {
    private static final String LOCALE_SEPARATOR = ",";
    private static final char QUALITY_SEPARATOR = ';';
    private static final float DEFAULT_QUALITY = 1.0f;
    private final List<AcceptLanguage> locales = new ArrayList<AcceptLanguage>(3);

    public I18NTokenizer(String header) {
        StringTokenizer tok = new StringTokenizer(header, LOCALE_SEPARATOR);
        while (tok.hasMoreTokens()) {
            AcceptLanguage acceptLang = new AcceptLanguage();
            String element = tok.nextToken().trim();
            int index = element.indexOf(59);
            if (index != -1) {
                String q = element.substring(index);
                element = element.substring(0, index);
                index = q.indexOf(61);
                if (index != -1) {
                    try {
                        acceptLang.quality = Float.valueOf(q.substring(index + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            acceptLang.locale = (index = (element = element.trim()).indexOf(45)) == -1 ? new Locale(element, "") : new Locale(element.substring(0, index), element.substring(index + 1));
            this.locales.add(acceptLang);
        }
        this.locales.sort(Collections.reverseOrder());
    }

    @Override
    public boolean hasNext() {
        return !this.locales.isEmpty();
    }

    @Override
    public Locale next() {
        if (this.locales.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.locales.remove((int)0).locale;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support remove()");
    }

    private static class AcceptLanguage
    implements Comparable<AcceptLanguage> {
        Locale locale;
        Float quality = Float.valueOf(1.0f);

        private AcceptLanguage() {
        }

        @Override
        public final int compareTo(AcceptLanguage acceptLang) {
            return this.quality.compareTo(acceptLang.quality);
        }
    }
}

