/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.gleaner;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.metadata.ann.AnnClass;
import org.codehaus.plexus.metadata.ann.AnnField;
import org.codehaus.plexus.metadata.ann.AnnReader;
import org.codehaus.plexus.metadata.gleaner.ClassComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.ComponentGleanerException;
import org.codehaus.plexus.metadata.gleaner.ComponentGleanerSupport;
import org.codehaus.plexus.util.IOUtil;

public class AnnotationComponentGleaner
extends ComponentGleanerSupport
implements ClassComponentGleaner {
    private static final String OBJECT_SLASHED_NAME = Object.class.getName().replace('.', '/');

    @Override
    public ComponentDescriptor<?> glean(String className, ClassLoader cl) throws ComponentGleanerException {
        assert (className != null);
        assert (cl != null);
        AnnClass annClass = this.readClass(className.replace('.', '/'), cl);
        if (Modifier.isAbstract(annClass.getAccess())) {
            return null;
        }
        Component anno = annClass.getAnnotation(Component.class);
        if (anno == null) {
            return null;
        }
        ComponentDescriptor component = new ComponentDescriptor();
        component.setRole(anno.role().getName());
        component.setRoleHint(this.filterEmptyAsNull(anno.hint()));
        component.setImplementation(className);
        component.setVersion(this.filterEmptyAsNull(anno.version()));
        component.setComponentType(this.filterEmptyAsNull(anno.type()));
        component.setInstantiationStrategy(this.filterEmptyAsNull(anno.instantiationStrategy()));
        component.setLifecycleHandler(this.filterEmptyAsNull(anno.lifecycleHandler()));
        component.setComponentProfile(this.filterEmptyAsNull(anno.profile()));
        component.setComponentComposer(this.filterEmptyAsNull(anno.composer()));
        component.setComponentConfigurator(this.filterEmptyAsNull(anno.configurator()));
        component.setComponentFactory(this.filterEmptyAsNull(anno.factory()));
        component.setDescription(this.filterEmptyAsNull(anno.description()));
        component.setAlias(this.filterEmptyAsNull(anno.alias()));
        component.setIsolatedRealm(anno.isolatedRealm());
        for (AnnClass c : this.getClasses(annClass, cl)) {
            for (AnnField field : c.getFields().values()) {
                PlexusConfiguration config;
                ComponentRequirement requirement = this.findRequirement(field, c, cl);
                if (requirement != null) {
                    component.addRequirement(requirement);
                }
                if ((config = this.findConfiguration(field, c, cl)) == null) continue;
                this.addChildConfiguration(component, config);
            }
        }
        return component;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnnClass readClass(String className, ClassLoader cl) throws ComponentGleanerException {
        AnnClass annClass;
        InputStream is;
        block6: {
            is = null;
            try {
                Enumeration<URL> en = cl.getResources(className + ".class");
                while (en.hasMoreElements()) {
                    URL url = en.nextElement();
                    if (!url.toString().startsWith("file:")) continue;
                    is = url.openStream();
                    annClass = AnnReader.read(is, cl);
                    break block6;
                }
                throw new ComponentGleanerException("Can't find class " + className);
            }
            catch (IOException ex) {
                throw new ComponentGleanerException("Can't read class " + className, ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)is);
        return annClass;
    }

    private AnnClass readClass2(String className, ClassLoader cl) throws ComponentGleanerException {
        AnnClass annClass;
        InputStream is = null;
        try {
            is = cl.getResourceAsStream(className + ".class");
            annClass = AnnReader.read(is, cl);
        }
        catch (IOException ex) {
            try {
                throw new ComponentGleanerException("Can't read class " + className, ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)is);
        return annClass;
    }

    private List<AnnClass> getClasses(AnnClass annClass, ClassLoader cl) throws ComponentGleanerException {
        assert (annClass != null);
        ArrayList<AnnClass> classes = new ArrayList<AnnClass>();
        while (annClass != null) {
            classes.add(annClass);
            String superName = annClass.getSuperName();
            if (superName == null || superName.equals(OBJECT_SLASHED_NAME)) break;
            annClass = this.readClass2(superName, cl);
        }
        return classes;
    }

    private ComponentRequirement findRequirement(AnnField field, AnnClass annClass, ClassLoader cl) throws ComponentGleanerException {
        ComponentRequirementList requirement;
        Class<?> type;
        assert (field != null);
        Requirement anno = field.getAnnotation(Requirement.class);
        if (anno == null) {
            return null;
        }
        String fieldType = field.getType();
        try {
            type = Class.forName(fieldType, false, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new ComponentGleanerException("Can't load class " + fieldType);
        }
        if (this.isRequirementListType(type)) {
            requirement = new ComponentRequirementList();
            String[] hints = anno.hints();
            if (hints != null && hints.length > 0) {
                requirement.setRoleHints(Arrays.asList(hints));
            }
        } else {
            requirement = new ComponentRequirement();
            requirement.setRoleHint(this.filterEmptyAsNull(anno.hint()));
        }
        if (anno.role().isAssignableFrom(Object.class)) {
            requirement.setRole(type.getName());
        } else {
            requirement.setRole(anno.role().getName());
        }
        requirement.setFieldName(field.getName());
        requirement.setFieldMappingType(type.getName());
        requirement.setOptional(anno.optional());
        return requirement;
    }

    private PlexusConfiguration findConfiguration(AnnField field, AnnClass c, ClassLoader cl) {
        assert (field != null);
        Configuration anno = field.getAnnotation(Configuration.class);
        if (anno == null) {
            return null;
        }
        String name = this.filterEmptyAsNull(anno.name());
        if (name == null) {
            name = field.getName();
        }
        name = this.deHump(name);
        XmlPlexusConfiguration config = new XmlPlexusConfiguration(name);
        String value = this.filterEmptyAsNull(anno.value());
        if (value != null) {
            config.setValue(value);
        }
        return config;
    }
}

