/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.ann;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import org.codehaus.plexus.metadata.ann.Ann;
import org.objectweb.asm.Type;

public class AnnInvocationHandler
implements InvocationHandler {
    private final Ann ann;
    private final ClassLoader cl;
    private final Class<?> c;

    public AnnInvocationHandler(Ann ann, ClassLoader cl, Class<?> c) {
        this.ann = ann;
        this.cl = cl;
        this.c = c;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        String name = m.getName();
        if ("toString".equals(name)) {
            StringBuilder sb = new StringBuilder(this.ann.getType());
            sb.append("[");
            String sep = "";
            for (Map.Entry<String, Object> e : this.ann.getParams().entrySet()) {
                sb.append(sep).append(e.getKey()).append("=").append(e.getValue());
                sep = "; ";
            }
            sb.append("]");
            return sb.toString();
        }
        Object value = this.ann.getParams().get(name);
        if (value != null) {
            if (value instanceof Type) {
                String className = ((Type)value).getClassName();
                try {
                    return Class.forName(className, false, this.cl);
                }
                catch (ClassNotFoundException ex) {
                    if (this.cl instanceof URLClassLoader) {
                        Object[] urls = ((URLClassLoader)this.cl).getURLs();
                        throw new RuntimeException("Unable to load class " + className + " from " + Arrays.toString(urls), ex);
                    }
                    throw new RuntimeException("Unable to load class " + className + " from " + this.cl, ex);
                }
            }
            return value;
        }
        Method am = this.c.getDeclaredMethod(m.getName(), m.getParameterTypes());
        return am.getDefaultValue();
    }
}

