/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zstd;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Compressor;
import org.codehaus.plexus.archiver.util.Streams;

public class ZstdCompressor
extends Compressor {
    private Integer level;
    private ZstdCompressorOutputStream zstdOut;

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Override
    public void compress() throws ArchiverException {
        try {
            BufferedOutputStream outStream = Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile()));
            ZstdCompressorOutputStream.Builder zstdOutBuilder = ZstdCompressorOutputStream.builder();
            zstdOutBuilder.setOutputStream((OutputStream)outStream);
            if (this.level != null) {
                zstdOutBuilder.setLevel(this.level.intValue());
            }
            this.zstdOut = zstdOutBuilder.get();
            this.compress(this.getSource(), (OutputStream)this.zstdOut);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Problem creating zstd " + ioe.getMessage(), ioe);
        }
    }

    @Override
    public void close() {
        try {
            if (this.zstdOut != null) {
                this.zstdOut.close();
                this.zstdOut = null;
            }
        }
        catch (IOException e) {
            throw new ArchiverException("Failure closing target.", e);
        }
    }
}

