/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.gzip;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Compressor;
import org.codehaus.plexus.util.IOUtil;

public class GZipCompressor
extends Compressor {
    private GZIPOutputStream zOut;

    public void compress() throws ArchiverException {
        try {
            this.zOut = new GZIPOutputStream(new FileOutputStream(this.getDestFile()));
            this.compress(this.getSource(), this.zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating gzip " + ioe.getMessage();
            throw new ArchiverException(msg, ioe);
        }
    }

    public void close() {
        IOUtil.close((OutputStream)this.zOut);
        this.zOut = null;
    }
}

