/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.gzip.GZipUnArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;

public class TarGZipUnArchiver
extends TarUnArchiver {
    public TarGZipUnArchiver() {
    }

    public TarGZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws ArchiverException {
        File tempTarFile;
        try {
            tempTarFile = File.createTempFile("tmp", ".tar");
        }
        catch (IOException e) {
            throw new ArchiverException("Cannot create temporary file for gzip uncompression", e);
        }
        tempTarFile.delete();
        File originalSourceFile = this.getSourceFile();
        try {
            GZipUnArchiver zipUnArchiver = new GZipUnArchiver(this.getSourceFile());
            zipUnArchiver.enableLogging(this.getLogger());
            zipUnArchiver.setDestFile(tempTarFile);
            zipUnArchiver.extract();
            this.setSourceFile(tempTarFile);
            super.execute();
        }
        finally {
            tempTarFile.delete();
            this.setSourceFile(originalSourceFile);
        }
    }
}

