/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationErrorHandler
implements ErrorHandler {
    private final List<ErrorRecord> errors = new ArrayList<ErrorRecord>();
    private final List<ErrorRecord> publicErrors = Collections.unmodifiableList(this.errors);
    private int warningCount = 0;
    private int errorCount = 0;
    private int fatalCount = 0;
    private File context;

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        ++this.warningCount;
        this.errors.add(new ErrorRecord(ErrorType.WARNING, exception, this.context));
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        ++this.errorCount;
        this.errors.add(new ErrorRecord(ErrorType.ERROR, exception, this.context));
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        ++this.fatalCount;
        this.errors.add(new ErrorRecord(ErrorType.FATAL, exception, this.context));
    }

    public List<ErrorRecord> getErrors() {
        return this.publicErrors;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalCount() {
        return this.fatalCount;
    }

    public void setContext(File context) {
        this.context = context;
    }

    public class ErrorRecord {
        final ErrorType type;
        final SAXParseException exception;
        final File context;

        public ErrorRecord(ErrorType type, SAXParseException exception, File context) {
            this.type = type;
            this.exception = exception;
            this.context = context;
        }

        public boolean isError() {
            return this.type == ErrorType.ERROR;
        }

        public boolean isWarning() {
            return this.type == ErrorType.WARNING;
        }

        public boolean isFatal() {
            return this.type == ErrorType.ERROR;
        }

        public ErrorType getType() {
            return this.type;
        }

        public SAXParseException getException() {
            return this.exception;
        }

        public File getContext() {
            return this.context;
        }
    }

    public static enum ErrorType {
        WARNING{

            public String toString() {
                return "warning";
            }
        }
        ,
        ERROR{

            public String toString() {
                return "error";
            }
        }
        ,
        FATAL{

            public String toString() {
                return "fatal error";
            }
        };

    }
}

