/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.utils.io.IOUtil;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.ResolverAdapter;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.ModelNode;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.stax2.XMLInputFactory2;

public class PomHelper {
    public static final String APACHE_MAVEN_PLUGINS_GROUPID = "org.apache.maven.plugins";
    private static final Set<String> IMPLICIT_PATHS = new HashSet<String>(Arrays.asList("/project/parent/groupId", "/project/parent/artifactId", "/project/parent/version", "/project/groupId", "/project/artifactId", "/project/version"));
    private static final Pattern PATTERN_PROJECT_VERSION = Pattern.compile("/project/version");
    private static final Pattern PATTERN_PROJECT_PARENT_VERSION = Pattern.compile("/project/parent/version");
    private static final Pattern PATTERN_PROJECT_DEPENDENCY = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency");
    private static final Pattern PATTERN_PROJECT_DEPENDENCY_VERSION = Pattern.compile("/project(/profiles/profile)?((/dependencyManagement)|(/build(/pluginManagement)?/plugins/plugin))?/dependencies/dependency((/groupId)|(/artifactId)|(/version))");
    private static final Pattern PATTERN_PROJECT_PLUGIN = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin");
    private static final Pattern PATTERN_PROJECT_PLUGIN_VERSION = Pattern.compile("/project(/profiles/profile)?((/build(/pluginManagement)?)|(/reporting))/plugins/plugin((/groupId)|(/artifactId)|(/version))");
    private final ArtifactFactory artifactFactory;
    private final ExpressionEvaluator expressionEvaluator;

    public PomHelper(ArtifactFactory artifactFactory, ExpressionEvaluator expressionEvaluator) {
        this.artifactFactory = artifactFactory;
        this.expressionEvaluator = expressionEvaluator;
    }

    public static Model getRawModel(MavenProject project) throws IOException {
        return PomHelper.getRawModel(project.getFile());
    }

    public static Model getRawModel(File moduleProjectFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(moduleProjectFile.toPath(), new OpenOption[0])));){
            Model result = PomHelper.getRawModel(reader);
            result.setPomFile(moduleProjectFile);
            Model model = result;
            return model;
        }
    }

    public static Model getRawModel(String modelString, File modelPath) throws IOException {
        try (StringReader reader = new StringReader(modelString);){
            Model result = PomHelper.getRawModel(reader);
            result.setPomFile(modelPath);
            Model model = result;
            return model;
        }
    }

    public static Model getRawModel(Reader reader) throws IOException {
        try {
            return new MavenXpp3Reader().read(reader);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static boolean setPropertyVersion(final MutableXMLStreamReader pom, final String profileId, final String property, final String value) throws XMLStreamException {
        pom.rewind();
        class PropertyVersionInternal {
            final Pattern propertyRegex;
            final Pattern matchScopeRegex;
            final Pattern profileIdRegex;

            PropertyVersionInternal() {
                this.propertyRegex = Pattern.compile((profileId == null ? "/project/properties/" : "/project/profiles/profile/properties/") + RegexUtils.quote(property));
                this.matchScopeRegex = profileId == null ? Pattern.compile("/project/properties") : Pattern.compile("/project/profiles/profile");
                this.profileIdRegex = profileId == null ? null : Pattern.compile("/project/profiles/profile/id");
            }

            boolean setPropertyVersion(String path, boolean inMatchScope) throws XMLStreamException {
                boolean replaced = false;
                while (!replaced && pom.hasNext()) {
                    pom.next();
                    if (pom.isStartElement()) {
                        String elementPath = path + "/" + pom.getLocalName();
                        if (this.propertyRegex.matcher(elementPath).matches()) {
                            pom.mark((Object)Marks.START);
                        } else if (this.matchScopeRegex.matcher(elementPath).matches()) {
                            inMatchScope = profileId == null;
                            pom.clearMark((Object)Marks.START);
                            pom.clearMark((Object)Marks.END);
                        } else if (profileId != null && this.profileIdRegex.matcher(elementPath).matches()) {
                            inMatchScope = profileId.trim().equals(pom.getElementText().trim());
                        }
                        if (pom.isEndElement()) continue;
                        replaced = this.setPropertyVersion(elementPath, inMatchScope);
                        continue;
                    }
                    if (!pom.isEndElement()) continue;
                    if (this.propertyRegex.matcher(path).matches()) {
                        pom.mark((Object)Marks.END);
                    } else if (this.matchScopeRegex.matcher(path).matches()) {
                        if (inMatchScope && pom.hasMark((Object)Marks.START) && pom.hasMark((Object)Marks.END)) {
                            pom.replaceBetween((Object)Marks.START, (Object)Marks.END, value);
                            replaced = true;
                        }
                        pom.clearMark((Object)Marks.START);
                        pom.clearMark((Object)Marks.END);
                    }
                    return replaced;
                }
                return replaced;
            }
        }
        return new PropertyVersionInternal().setPropertyVersion("", false);
    }

    public static boolean setProjectVersion(MutableXMLStreamReader pom, String value) throws XMLStreamException {
        return PomHelper.setElementValue(pom, "/project", "version", value, false);
    }

    public static boolean setElementValue(MutableXMLStreamReader pom, String parentPath, String elementName, String value) throws XMLStreamException {
        pom.rewind();
        return PomHelper.setElementValue(pom, parentPath, elementName, value, true);
    }

    public static boolean setElementValue(final MutableXMLStreamReader pom, final String parentPath, final String elementName, final String value, final boolean shouldCreate) throws XMLStreamException {
        pom.rewind();
        class ElementValueInternal {
            private final String parentName;
            private final String superParentPath;

            ElementValueInternal() {
                int lastDelimeterIndex = string.lastIndexOf(47);
                this.parentName = string.substring(lastDelimeterIndex + 1);
                this.superParentPath = string.substring(0, lastDelimeterIndex);
            }

            boolean process(String currentPath) throws XMLStreamException {
                boolean replacementMade = false;
                while (!replacementMade && pom.hasNext()) {
                    pom.next();
                    if (pom.isStartElement()) {
                        if (currentPath.equals(parentPath) && elementName.equals(pom.getLocalName())) {
                            pom.mark((Object)Marks.CHILD_START);
                        } else if (currentPath.equals(this.superParentPath) && pom.getLocalName().equals(this.parentName)) {
                            pom.mark((Object)Marks.PARENT_START);
                        }
                        replacementMade = this.process(currentPath + "/" + pom.getLocalName());
                        continue;
                    }
                    if (!pom.isEndElement()) continue;
                    if (currentPath.equals(parentPath + "/" + elementName)) {
                        this.replaceValueInChild();
                        replacementMade = true;
                        continue;
                    }
                    if (shouldCreate && currentPath.equals(parentPath)) {
                        this.replaceValueInParent();
                        replacementMade = true;
                        continue;
                    }
                    return false;
                }
                return replacementMade;
            }

            private void replaceValueInChild() {
                pom.mark((Object)Marks.END_ELEMENT);
                if (!pom.getBetween((Object)Marks.CHILD_START, (Object)Marks.END_ELEMENT).isEmpty()) {
                    pom.replaceBetween((Object)Marks.CHILD_START, (Object)Marks.END_ELEMENT, value);
                } else {
                    pom.replace(String.format("<%1$s>%2$s</%1$s>", elementName, value));
                }
            }

            private void replaceValueInParent() {
                pom.mark((Object)Marks.END_ELEMENT);
                if (pom.hasMark((Object)Marks.PARENT_START)) {
                    if (!pom.getBetween((Object)Marks.PARENT_START, (Object)Marks.END_ELEMENT).isEmpty()) {
                        pom.replace(String.format("<%2$s>%3$s</%2$s></%1$s>", this.parentName, elementName, value));
                    } else {
                        pom.replace(String.format("<%1$s><%2$s>%3$s</%2$s></%1$s>", this.parentName, elementName, value));
                    }
                } else {
                    pom.replace(String.format("<%1$s><%2$s>%3$s</%2$s></%1$s>", this.parentName, elementName, value));
                }
            }
        }
        return new ElementValueInternal().process("");
    }

    static <T> T executeOnPatternFound(String path, MutableXMLStreamReader pom, Pattern pattern, Supplier<T> onPatternFound) throws XMLStreamException {
        T result = null;
        while (result == null && pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                String elementPath = path + "/" + pom.getLocalName();
                if (pattern.matcher(elementPath).matches()) {
                    pom.mark((Object)Marks.START);
                }
                result = PomHelper.executeOnPatternFound(elementPath, pom, pattern, onPatternFound);
                continue;
            }
            if (!pom.isEndElement()) continue;
            if (!pattern.matcher(path).matches()) break;
            pom.mark((Object)Marks.END);
            if (pom.hasMark((Object)Marks.START)) {
                return onPatternFound.get();
            }
            pom.clearMark((Object)Marks.START);
            pom.clearMark((Object)Marks.END);
            break;
        }
        return result;
    }

    public static String getProjectVersion(MutableXMLStreamReader pom) throws XMLStreamException {
        pom.rewind();
        return PomHelper.executeOnPatternFound("", pom, PATTERN_PROJECT_VERSION, () -> pom.getBetween((Object)Marks.START, (Object)Marks.END).trim());
    }

    public static boolean setProjectParentVersion(MutableXMLStreamReader pom, String value) throws XMLStreamException {
        pom.rewind();
        return Optional.ofNullable(PomHelper.executeOnPatternFound("", pom, PATTERN_PROJECT_PARENT_VERSION, () -> {
            pom.replaceBetween((Object)Marks.START, (Object)Marks.END, value);
            return true;
        })).orElse(false);
    }

    public static boolean setDependencyVersion(MutableXMLStreamReader pom, String groupId, String artifactId, String oldVersion, String newVersion, Model model, Log logger) throws XMLStreamException {
        Map<String, String> implicitProperties = PomHelper.getImplicitProperties(pom, model);
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        pom.rewind();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        while (pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                stack.push(path);
                path = path + "/" + pom.getLocalName();
                if (PATTERN_PROJECT_DEPENDENCY.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark((Object)Marks.START);
                    pom.clearMark((Object)Marks.END);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && PATTERN_PROJECT_DEPENDENCY_VERSION.matcher(path).matches()) {
                    if ("groupId".equals(pom.getLocalName())) {
                        haveGroupId = groupId.equals(PomHelper.evaluate(pom.getElementText().trim(), implicitProperties, logger));
                    } else if ("artifactId".equals(pom.getLocalName())) {
                        haveArtifactId = artifactId.equals(PomHelper.evaluate(pom.getElementText().trim(), implicitProperties, logger));
                    } else if ("version".equals(pom.getLocalName())) {
                        pom.mark((Object)Marks.START);
                    }
                }
            }
            if (!pom.isEndElement()) continue;
            if (PATTERN_PROJECT_DEPENDENCY_VERSION.matcher(path).matches() && "version".equals(pom.getLocalName())) {
                pom.mark((Object)Marks.END);
                String compressedPomVersion = StringUtils.deleteWhitespace((String)pom.getBetween((Object)Marks.START, (Object)Marks.END).trim());
                String compressedOldVersion = StringUtils.deleteWhitespace((String)oldVersion);
                try {
                    haveOldVersion = PomHelper.isVersionOverlap(compressedOldVersion, compressedPomVersion);
                }
                catch (InvalidVersionSpecificationException e) {
                    haveOldVersion = compressedOldVersion.equals(compressedPomVersion);
                }
            } else if (PATTERN_PROJECT_DEPENDENCY.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark((Object)Marks.START) && pom.hasMark((Object)Marks.END) && haveGroupId && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween((Object)Marks.START, (Object)Marks.END, newVersion);
                    madeReplacement = true;
                }
                pom.clearMark((Object)Marks.START);
                pom.clearMark((Object)Marks.END);
                haveArtifactId = false;
                haveGroupId = false;
                haveOldVersion = false;
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    static Map<String, String> getImplicitProperties(MutableXMLStreamReader pom, Model model) throws XMLStreamException {
        Map<String, String> implicitProperties = model.getProperties().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        pom.rewind();
        PomHelper.getImplicitProperties("", pom, implicitProperties);
        List<Pair> parentProperties = implicitProperties.entrySet().stream().filter(e -> ((String)e.getKey()).contains(".parent")).map(e -> Pair.of((Object)((String)e.getKey()).replace(".parent", ""), (Object)((String)e.getValue()))).collect(Collectors.toList());
        parentProperties.forEach(p -> implicitProperties.putIfAbsent((String)p.getLeft(), (String)p.getRight()));
        return implicitProperties;
    }

    private static void getImplicitProperties(String path, MutableXMLStreamReader pom, Map<String, String> acc) throws XMLStreamException {
        while (pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                String elementPath = path + "/" + pom.getLocalName();
                if (IMPLICIT_PATHS.contains(elementPath)) {
                    String elementText = pom.getElementText().trim();
                    acc.put(elementPath.substring(1).replace('/', '.'), elementText);
                    continue;
                }
                PomHelper.getImplicitProperties(elementPath, pom, acc);
                continue;
            }
            if (!pom.isEndElement()) continue;
            return;
        }
    }

    public static String evaluate(String expr, Map<String, String> properties, Log logger) {
        if (expr == null) {
            return null;
        }
        return PomHelper.extractExpression(expr).map(expression -> {
            String value = (String)properties.get(expression);
            if (value != null) {
                int exprStartDelimiter = value.indexOf("${");
                if (exprStartDelimiter >= 0) {
                    value = value.substring(0, exprStartDelimiter) + PomHelper.evaluate(value.substring(exprStartDelimiter), properties, logger);
                }
            } else {
                logger.debug((CharSequence)("expression: " + expression + " no value "));
            }
            return value == null ? expr : value;
        }).orElseGet(() -> {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                String retVal = expr.substring(0, index) + PomHelper.evaluate(expr.substring(index, lastIndex + 1), properties, logger) + PomHelper.evaluate(expr.substring(lastIndex + 1), properties, logger);
                if (index > 0 && expr.charAt(index - 1) == '$') {
                    retVal = expr.substring(0, index - 1) + retVal;
                }
                return retVal;
            }
            return expr.contains("$$") ? expr.replaceAll("\\$\\$", "\\$") : expr;
        });
    }

    public static Optional<String> extractExpression(String expr) {
        return Optional.ofNullable(expr).map(String::trim).filter(e -> e.startsWith("${") && e.indexOf("}") == e.length() - 1).map(e -> e.substring(2, e.length() - 1));
    }

    static boolean isVersionOverlap(String leftVersionOrRange, String rightVersionOrRange) throws InvalidVersionSpecificationException {
        VersionRange pomVersionRange = PomHelper.createVersionRange(leftVersionOrRange);
        if (!pomVersionRange.hasRestrictions()) {
            return true;
        }
        VersionRange oldVersionRange = PomHelper.createVersionRange(rightVersionOrRange);
        if (!oldVersionRange.hasRestrictions()) {
            return true;
        }
        VersionRange result = oldVersionRange.restrict(pomVersionRange);
        return result.hasRestrictions();
    }

    private static VersionRange createVersionRange(String versionOrRange) throws InvalidVersionSpecificationException {
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)versionOrRange);
        if (versionRange.getRecommendedVersion() != null) {
            versionRange = VersionRange.createFromVersionSpec((String)("[" + versionOrRange + "]"));
        }
        return versionRange;
    }

    public static boolean setPluginVersion(MutableXMLStreamReader pom, String groupId, String artifactId, String oldVersion, String newVersion) throws XMLStreamException {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String path = "";
        boolean inMatchScope = false;
        boolean madeReplacement = false;
        boolean haveGroupId = false;
        boolean needGroupId = groupId != null && !APACHE_MAVEN_PLUGINS_GROUPID.equals(groupId);
        boolean haveArtifactId = false;
        boolean haveOldVersion = false;
        pom.rewind();
        while (pom.hasNext()) {
            pom.next();
            if (pom.isStartElement()) {
                stack.push(path);
                String elementName = pom.getLocalName();
                path = path + "/" + elementName;
                if (PATTERN_PROJECT_PLUGIN.matcher(path).matches()) {
                    inMatchScope = true;
                    pom.clearMark((Object)Marks.START);
                    pom.clearMark((Object)Marks.END);
                    haveGroupId = false;
                    haveArtifactId = false;
                    haveOldVersion = false;
                } else if (inMatchScope && PATTERN_PROJECT_PLUGIN_VERSION.matcher(path).matches()) {
                    if ("groupId".equals(elementName)) {
                        haveGroupId = pom.getElementText().trim().equals(groupId);
                    } else if ("artifactId".equals(elementName)) {
                        haveArtifactId = artifactId.equals(pom.getElementText().trim());
                    } else if ("version".equals(elementName)) {
                        pom.mark((Object)Marks.START);
                    }
                }
            }
            if (!pom.isEndElement()) continue;
            if (PATTERN_PROJECT_PLUGIN_VERSION.matcher(path).matches() && "version".equals(pom.getLocalName())) {
                pom.mark((Object)Marks.END);
                try {
                    haveOldVersion = PomHelper.isVersionOverlap(oldVersion, pom.getBetween((Object)Marks.START, (Object)Marks.END).trim());
                }
                catch (InvalidVersionSpecificationException e) {
                    haveOldVersion = oldVersion.equals(pom.getBetween((Object)Marks.START, (Object)Marks.END).trim());
                }
            } else if (PATTERN_PROJECT_PLUGIN.matcher(path).matches()) {
                if (inMatchScope && pom.hasMark((Object)Marks.START) && pom.hasMark((Object)Marks.END) && (haveGroupId || !needGroupId) && haveArtifactId && haveOldVersion) {
                    pom.replaceBetween((Object)Marks.START, (Object)Marks.END, newVersion);
                    madeReplacement = true;
                    pom.clearMark((Object)Marks.START);
                    pom.clearMark((Object)Marks.END);
                    haveArtifactId = false;
                    haveGroupId = false;
                    haveOldVersion = false;
                }
                inMatchScope = false;
            }
            path = (String)stack.pop();
        }
        return madeReplacement;
    }

    static Map<MavenProject, Model> getRawModelWithParents(MavenProject project) throws IOException {
        TreeMap<MavenProject, Model> models = new TreeMap<MavenProject, Model>((p1, p2) -> {
            for (MavenProject p = p1; p != null; p = p.getParent()) {
                if (p != p2) continue;
                return p == p1 ? 0 : -1;
            }
            return 1;
        });
        for (MavenProject p = project; p != null; p = p.getParent()) {
            models.put(p, p.getFile() != null ? PomHelper.getRawModel(p) : p.getOriginalModel());
        }
        return models;
    }

    public PropertyVersionsBuilder[] getPropertyVersionsBuilders(ResolverAdapter resolverAdapter, Log log, MavenProject project, boolean includeParent) throws ExpressionEvaluationException, IOException {
        Map<MavenProject, Model> reactorModels = includeParent ? PomHelper.getRawModelWithParents(project) : Collections.singletonMap(project, PomHelper.getRawModel(project));
        Set<String> activeProfileIds = project.getActiveProfiles().stream().map(Profile::getId).collect(Collectors.toSet());
        TreeMap<String, PropertyVersionsBuilder> propertiesMap = new TreeMap<String, PropertyVersionsBuilder>();
        reactorModels.values().forEach(model -> {
            this.processProfiles(resolverAdapter, log, (Map<String, PropertyVersionsBuilder>)propertiesMap, (Model)model, activeProfileIds);
            this.putPropertiesIfAbsent(resolverAdapter, log, propertiesMap, null, model.getProperties());
        });
        MavenProject currentProject = project;
        while (currentProject != null) {
            Model model2 = reactorModels.get(currentProject);
            if (model2 != null) {
                this.processModel(propertiesMap, model2, activeProfileIds);
            }
            currentProject = includeParent ? currentProject.getParent() : null;
        }
        propertiesMap.values().removeIf(versions -> !versions.isAssociated());
        return propertiesMap.values().toArray(new PropertyVersionsBuilder[0]);
    }

    private void processProfiles(ResolverAdapter resolverAdapter, Log log, Map<String, PropertyVersionsBuilder> propertiesMap, Model model, Set<String> activeProfileIds) {
        model.getProfiles().stream().filter(profile -> activeProfileIds.contains(profile.getId())).forEach(profile -> {
            try {
                this.putPropertiesIfAbsent(resolverAdapter, log, propertiesMap, profile.getId(), profile.getProperties());
                this.processDependencies(propertiesMap, profile.getDependencyManagement(), profile.getDependencies());
                this.processBuild(propertiesMap, profile.getBuild());
                this.processReporting(propertiesMap, profile.getReporting());
            }
            catch (ExpressionEvaluationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void processModel(Map<String, PropertyVersionsBuilder> propertiesMap, Model model, Set<String> activeProfileIds) throws ExpressionEvaluationException {
        this.processDependencies(propertiesMap, model.getDependencyManagement(), model.getDependencies());
        this.processBuild(propertiesMap, (BuildBase)model.getBuild());
        this.processReporting(propertiesMap, model.getReporting());
        for (Profile profile : model.getProfiles()) {
            if (!activeProfileIds.contains(profile.getId())) continue;
            this.processDependencies(propertiesMap, profile.getDependencyManagement(), profile.getDependencies());
        }
    }

    private void processDependencies(Map<String, PropertyVersionsBuilder> propertiesMap, DependencyManagement depMgmt, List<Dependency> dependencies) throws ExpressionEvaluationException {
        if (depMgmt != null) {
            this.addDependencyAssocations(propertiesMap, depMgmt.getDependencies(), false);
        }
        this.addDependencyAssocations(propertiesMap, dependencies, false);
    }

    private void processBuild(Map<String, PropertyVersionsBuilder> propertiesMap, BuildBase build) throws ExpressionEvaluationException {
        if (build != null) {
            if (build.getPluginManagement() != null) {
                this.addPluginAssociations(propertiesMap, build.getPluginManagement().getPlugins());
            }
            this.addPluginAssociations(propertiesMap, build.getPlugins());
        }
    }

    private void processReporting(Map<String, PropertyVersionsBuilder> propertiesMap, Reporting reporting) throws ExpressionEvaluationException {
        if (reporting != null) {
            this.addReportPluginAssociations(propertiesMap, reporting.getPlugins());
        }
    }

    private void addPluginAssociations(Map<String, PropertyVersionsBuilder> result, List<Plugin> plugins) throws ExpressionEvaluationException {
        if (plugins == null) {
            return;
        }
        for (Plugin plugin : plugins) {
            String version = plugin.getVersion();
            if (version != null && version.contains("${") && version.indexOf(125) != -1) {
                version = StringUtils.deleteWhitespace((String)version);
                for (PropertyVersionsBuilder property : result.values()) {
                    String propertyRef = "${" + property.getName() + "}";
                    if (!version.contains(propertyRef)) continue;
                    String groupId = plugin.getGroupId();
                    groupId = StringUtils.isBlank((CharSequence)groupId) ? APACHE_MAVEN_PLUGINS_GROUPID : (String)this.expressionEvaluator.evaluate(groupId);
                    String artifactId = plugin.getArtifactId();
                    if (StringUtils.isBlank((CharSequence)artifactId)) continue;
                    artifactId = (String)this.expressionEvaluator.evaluate(artifactId);
                    String evaluatedVersion = (String)this.expressionEvaluator.evaluate(plugin.getVersion());
                    property.withAssociation(this.artifactFactory.createMavenPluginArtifact(groupId, artifactId, evaluatedVersion), true);
                    if (propertyRef.equals(version)) continue;
                    PomHelper.addBounds(property, version, propertyRef);
                }
            }
            this.addDependencyAssocations(result, plugin.getDependencies(), true);
        }
    }

    private void addReportPluginAssociations(Map<String, PropertyVersionsBuilder> result, List<ReportPlugin> reportPlugins) throws ExpressionEvaluationException {
        if (reportPlugins == null) {
            return;
        }
        for (ReportPlugin plugin : reportPlugins) {
            String version = plugin.getVersion();
            if (version == null || !version.contains("${") || version.indexOf(125) == -1) continue;
            version = StringUtils.deleteWhitespace((String)version);
            for (PropertyVersionsBuilder property : result.values()) {
                String propertyRef = "${" + property.getName() + "}";
                if (!version.contains(propertyRef)) continue;
                String groupId = plugin.getGroupId();
                groupId = StringUtils.isBlank((CharSequence)groupId) ? APACHE_MAVEN_PLUGINS_GROUPID : (String)this.expressionEvaluator.evaluate(groupId);
                String artifactId = plugin.getArtifactId();
                if (StringUtils.isBlank((CharSequence)artifactId)) continue;
                artifactId = (String)this.expressionEvaluator.evaluate(artifactId);
                String versionEvaluated = (String)this.expressionEvaluator.evaluate(plugin.getVersion());
                property.withAssociation(this.artifactFactory.createMavenPluginArtifact(groupId, artifactId, versionEvaluated), true);
                if (propertyRef.equals(version)) continue;
                PomHelper.addBounds(property, version, propertyRef);
            }
        }
    }

    private void addDependencyAssocations(Map<String, PropertyVersionsBuilder> result, List<Dependency> dependencies, boolean usePluginRepositories) throws ExpressionEvaluationException {
        if (dependencies == null) {
            return;
        }
        for (Dependency dependency : dependencies) {
            String version = dependency.getVersion();
            if (version == null || !version.contains("${") || version.indexOf(125) == -1) continue;
            version = StringUtils.deleteWhitespace((String)version);
            for (PropertyVersionsBuilder property : result.values()) {
                String groupId;
                String propertyRef = "${" + property.getName() + "}";
                if (!version.contains(propertyRef) || StringUtils.isBlank((CharSequence)(groupId = dependency.getGroupId()))) continue;
                groupId = (String)this.expressionEvaluator.evaluate(groupId);
                String artifactId = dependency.getArtifactId();
                if (StringUtils.isBlank((CharSequence)artifactId)) continue;
                artifactId = (String)this.expressionEvaluator.evaluate(artifactId);
                String versionEvaluated = (String)this.expressionEvaluator.evaluate(dependency.getVersion());
                property.withAssociation(this.artifactFactory.createArtifact(groupId, artifactId, versionEvaluated, dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional()), usePluginRepositories);
                if (propertyRef.equals(version)) continue;
                PomHelper.addBounds(property, version, propertyRef);
            }
        }
    }

    private static void addBounds(PropertyVersionsBuilder builder, String rawVersionRange, String propertyRef) {
        Pattern lowerBound = Pattern.compile("([(\\[])([^,]*)," + RegexUtils.quote(propertyRef) + "([)\\]])");
        Pattern upperBound = Pattern.compile("([(\\[])" + RegexUtils.quote(propertyRef) + ",([^,]*)([)\\]])");
        Matcher m = lowerBound.matcher(rawVersionRange);
        if (m.find()) {
            boolean includeLower = "[".equals(m.group(1));
            String lowerLimit = m.group(2);
            if (StringUtils.isNotEmpty((CharSequence)lowerLimit)) {
                builder.withLowerBound(lowerLimit, includeLower);
            }
        }
        if ((m = upperBound.matcher(rawVersionRange)).find()) {
            boolean includeUpper = "[".equals(m.group(3));
            String upperLimit = m.group(2);
            if (StringUtils.isNotEmpty((CharSequence)upperLimit)) {
                builder.withUpperBound(upperLimit, includeUpper);
            }
        }
    }

    private void putPropertiesIfAbsent(ResolverAdapter resolverAdapter, Log log, Map<String, PropertyVersionsBuilder> result, String profileId, Properties properties) {
        Optional.ofNullable(properties).map(Properties::stringPropertyNames).ifPresent(propertyNames -> propertyNames.forEach(propertyName -> result.putIfAbsent((String)propertyName, new PropertyVersionsBuilder(resolverAdapter, profileId, (String)propertyName, log))));
    }

    public static Set<String> getAllChildModules(MavenProject project, Log logger) {
        return PomHelper.getAllChildModules(project.getOriginalModel(), logger);
    }

    public static Set<String> getAllChildModules(Model model, Log logger) {
        logger.debug((CharSequence)("Finding child modules of " + model));
        Set childModules = Stream.concat(model.getModules().stream(), model.getProfiles().stream().flatMap(profile -> profile.getModules().stream())).collect(TreeSet::new, Set::add, Set::addAll);
        PomHelper.debugModules(logger, "Child modules:", childModules);
        return childModules;
    }

    public static void debugModules(Log logger, String message, Collection<String> modules) {
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)message);
            if (modules.isEmpty()) {
                logger.debug((CharSequence)"None.");
            } else {
                modules.forEach(module -> logger.debug((CharSequence)("  " + module)));
            }
        }
    }

    public static String getVersion(Model model) {
        return Optional.ofNullable(model.getVersion()).orElse(Optional.ofNullable(model.getParent()).map(Parent::getVersion).orElse(null));
    }

    public static boolean isExplicitVersion(Model model) {
        return model.getVersion() != null;
    }

    public static String getArtifactId(Model model) {
        return Optional.ofNullable(model.getArtifactId()).orElse(Optional.ofNullable(model.getParent()).map(Parent::getArtifactId).orElse(null));
    }

    public static String getGroupId(Model model) {
        return Optional.ofNullable(model.getGroupId()).orElse(Optional.ofNullable(model.getParent()).map(Parent::getGroupId).orElse(null));
    }

    public static MavenProject getLocalRoot(ProjectBuilder projectBuilder, MavenSession mavenSession, Log logger) {
        File parentDir;
        logger.info((CharSequence)"Searching for local aggregator root...");
        MavenProject project = mavenSession.getCurrentProject();
        while ((parentDir = project.getBasedir().getParentFile()) != null && parentDir.isDirectory()) {
            logger.debug((CharSequence)("Checking to see if " + parentDir + " is an aggregator parent"));
            File parentFile = new File(parentDir, "pom.xml");
            if (!parentFile.isFile()) break;
            try {
                ProjectBuildingResult result = projectBuilder.build(parentFile, PomHelper.createProjectBuilderRequest(mavenSession, new Consumer[0]));
                if (!result.getProblems().isEmpty()) {
                    logger.warn((CharSequence)"Problems encountered during the computation of the local aggregation root.");
                    result.getProblems().forEach(p -> logger.warn((CharSequence)("\t" + p.getMessage())));
                }
                if (PomHelper.getAllChildModules(result.getProject(), logger).contains(project.getBasedir().getName())) {
                    logger.debug((CharSequence)(parentDir + " is an aggregator parent"));
                    project = result.getProject();
                    continue;
                }
                logger.debug((CharSequence)(parentDir + " is not an aggregator parent"));
                break;
            }
            catch (ProjectBuildingException e) {
                logger.warn((Throwable)e);
                break;
            }
        }
        logger.debug((CharSequence)("Local aggregation root is " + project.getBasedir()));
        return project;
    }

    @SafeVarargs
    public static ProjectBuildingRequest createProjectBuilderRequest(final MavenSession mavenSession, final Consumer<ProjectBuildingRequest> ... initializers) {
        return new DefaultProjectBuildingRequest(){
            {
                this.setValidationLevel(0);
                this.setResolveDependencies(false);
                this.setLocalRepository(mavenSession.getLocalRepository());
                this.setRemoteRepositories(mavenSession.getCurrentProject().getRemoteArtifactRepositories());
                this.setBuildStartTime(mavenSession.getStartTime());
                this.setUserProperties(mavenSession.getUserProperties());
                this.setSystemProperties(mavenSession.getSystemProperties());
                this.setActiveProfileIds(mavenSession.getRequest().getActiveProfiles());
                this.setInactiveProfileIds(mavenSession.getRequest().getInactiveProfiles());
                this.setRepositorySession(mavenSession.getRepositorySession());
                Arrays.stream(initializers).forEach(i -> i.accept(this));
            }
        };
    }

    public static List<ModelNode> getRawModelTree(ModelNode rootNode, Log logger) throws UncheckedIOException {
        Path baseDir = rootNode.getModel().getPomFile().getParentFile().toPath();
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        result.add(rootNode);
        result.addAll(PomHelper.getAllChildModules(rootNode.getModel(), logger).stream().map(baseDir::resolve).map(path -> Files.isDirectory(path, new LinkOption[0]) ? path.resolve("pom.xml") : path).map(pomFile -> {
            try {
                MutableXMLStreamReader pom = new MutableXMLStreamReader((Path)pomFile);
                return new ModelNode(rootNode, PomHelper.getRawModel(pom.getSource(), pomFile.toFile()), pom);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not open " + pomFile, e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Could not parse " + pomFile, e);
            }
        }).flatMap(node -> PomHelper.getRawModelTree(node, logger).stream()).collect(Collectors.toList()));
        return result;
    }

    public static Optional<ModelNode> findProperty(String propertyName, ModelNode node) {
        if (Optional.ofNullable(node.getModel().getProperties()).map(properties -> properties.getProperty(propertyName)).isPresent()) {
            return Optional.of(node);
        }
        return node.getParent().flatMap(parent -> PomHelper.findProperty(propertyName, parent));
    }

    public static Map<File, Model> getChildModels(MavenProject project, Log logger) throws IOException {
        LinkedHashMap<File, Model> result = new LinkedHashMap<File, Model>();
        Model model = PomHelper.getRawModel(project);
        result.put(project.getFile(), model);
        result.putAll(PomHelper.getChildModels(model, logger));
        return result;
    }

    private static Map<File, Model> getChildModels(Model model, Log logger) {
        LinkedHashMap<File, Model> result = new LinkedHashMap<File, Model>();
        LinkedHashMap childResults = new LinkedHashMap();
        File baseDir = model.getPomFile().getParentFile();
        PomHelper.getAllChildModules(model, logger).stream().map(moduleName -> new File(baseDir, (String)moduleName)).map(file -> file.isFile() ? file : new File((File)file, "pom.xml")).filter(File::exists).forEach(pomFile -> {
            try {
                Model moduleModel = PomHelper.getRawModel(pomFile);
                result.put((File)pomFile, moduleModel);
                childResults.putAll(PomHelper.getChildModels(moduleModel, logger));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        result.putAll(childResults);
        return result;
    }

    public static Map<File, Model> getChildModels(Map<File, Model> reactor, String groupId, String artifactId) {
        LinkedHashMap<File, Model> result = new LinkedHashMap<File, Model>();
        for (Map.Entry<File, Model> entry : reactor.entrySet()) {
            File path = entry.getKey();
            Model model = entry.getValue();
            Parent parent = model.getParent();
            if (parent == null || !groupId.equals(parent.getGroupId()) || !artifactId.equals(parent.getArtifactId())) continue;
            result.put(path, model);
        }
        return result;
    }

    public static Model getModel(Map<File, Model> reactor, String groupId, String artifactId) {
        return reactor.values().stream().filter(model -> (groupId == null || groupId.equals(PomHelper.getGroupId(model))) && artifactId.equals(PomHelper.getArtifactId(model))).findAny().orElse(null);
    }

    public static Map.Entry<File, Model> getModelEntry(Map<File, Model> reactor, String groupId, String artifactId) {
        return reactor.entrySet().stream().filter(e -> (groupId == null || groupId.equals(PomHelper.getGroupId((Model)e.getValue()))) && artifactId.equals(PomHelper.getArtifactId((Model)e.getValue()))).findAny().orElse(null);
    }

    public static int getReactorParentCount(Map<File, Model> reactor, Model model) {
        if (model.getParent() == null) {
            return 0;
        }
        Model parentModel = PomHelper.getModel(reactor, model.getParent().getGroupId(), model.getParent().getArtifactId());
        if (parentModel == null) {
            return 0;
        }
        return PomHelper.getReactorParentCount(reactor, parentModel) + 1;
    }

    public static Pair<String, Charset> readXml(InputStream inputStream) throws IOException, XMLStreamException {
        try (BufferedInputStream buffer = new BufferedInputStream(inputStream);){
            buffer.mark(16384);
            XMLInputFactory2 factory = (XMLInputFactory2)XMLInputFactory2.newInstance();
            factory.configureForLowMemUsage();
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader((InputStream)buffer);
            xmlStreamReader.close();
            Charset encoding = Optional.ofNullable(xmlStreamReader.getEncoding()).map(Charset::forName).orElse(Charset.defaultCharset());
            buffer.reset();
            Pair pair = Pair.of((Object)IOUtil.toString((InputStream)buffer, (String)encoding.toString()), (Object)encoding);
            return pair;
        }
    }

    public static Pair<String, Charset> readXml(File file) throws IOException, XMLStreamException {
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Pair<String, Charset> pair = PomHelper.readXml(is);
            return pair;
        }
    }

    public static String getGAV(Model model) {
        return PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model) + ":" + PomHelper.getVersion(model);
    }

    static enum Marks {
        CHILD_START,
        PARENT_START,
        END_ELEMENT,
        START,
        END;

    }
}

