/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.ArtifactVersions;

public class PluginUpdatesDetails
extends ArtifactVersions
implements Comparable<ArtifactVersions> {
    private final Map<Dependency, ArtifactVersions> dependencyVersions;
    private final boolean includeSnapshots;

    public PluginUpdatesDetails(ArtifactVersions artifactVersions, Map<Dependency, ArtifactVersions> dependencyVersions, boolean includeSnapshots) {
        super(artifactVersions);
        Objects.requireNonNull(artifactVersions);
        Objects.requireNonNull(dependencyVersions);
        this.dependencyVersions = dependencyVersions;
        this.includeSnapshots = includeSnapshots;
    }

    public boolean isIncludeSnapshots() {
        return this.includeSnapshots;
    }

    public Map<Dependency, ArtifactVersions> getDependencyVersions() {
        return this.dependencyVersions;
    }

    public void addDependencyVersions(Map<Dependency, ArtifactVersions> dependencyVersions) {
        this.dependencyVersions.putAll(dependencyVersions);
    }

    public boolean isArtifactUpdateAvailable() {
        ArtifactVersion[] updates = this.getAllUpdates(Optional.empty(), this.includeSnapshots);
        return updates != null && updates.length > 0;
    }

    public boolean isDependencyUpdateAvailable() {
        return this.dependencyVersions.values().stream().anyMatch(versions -> {
            ArtifactVersion[] dependencyUpdates = versions.getAllUpdates(Optional.empty(), this.includeSnapshots);
            return dependencyUpdates != null && dependencyUpdates.length > 0;
        });
    }

    public boolean isUpdateAvailable() {
        return this.isArtifactUpdateAvailable() || this.isDependencyUpdateAvailable();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginUpdatesDetails)) {
            return false;
        }
        PluginUpdatesDetails other = (PluginUpdatesDetails)o;
        return this.includeSnapshots == other.includeSnapshots && Objects.equals(this.dependencyVersions, other.dependencyVersions) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getArtifact(), Arrays.hashCode(this.getVersions(true)), this.includeSnapshots, this.dependencyVersions);
    }

    @Override
    public int compareTo(ArtifactVersions other) {
        if (!(other instanceof PluginUpdatesDetails)) {
            return -1;
        }
        PluginUpdatesDetails that = (PluginUpdatesDetails)other;
        int r = super.compareTo(that);
        return r != 0 ? r : Comparator.comparing(PluginUpdatesDetails::isIncludeSnapshots).thenComparing(p -> Optional.ofNullable(p.dependencyVersions).map(Map::values).map(c -> Optional.ofNullable(that.dependencyVersions).map(Map::values).map(c::containsAll).orElse(true)).orElse(false)).compare(this, that);
    }
}

