/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.UseLatestVersionsMojoBase;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="use-latest-versions", threadSafe=true)
public class UseLatestVersionsMojo
extends UseLatestVersionsMojoBase {
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates = true;
    @Parameter(property="allowDowngrade", defaultValue="false")
    private boolean allowDowngrade;

    @Inject
    public UseLatestVersionsMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.allowDowngrade && this.allowSnapshots) {
            throw new MojoExecutionException("allowDowngrade is only valid with allowSnapshots equal to false");
        }
        super.execute();
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useLatestVersions(pom, dependencyManagement.getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useLatestVersions(pom, this.getProject().getDependencies(), DependencyChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.useLatestVersions(pom, Collections.singletonList(this.getParentDependency()), DependencyChangeRecord.ChangeKind.PARENT);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useLatestVersions(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies, DependencyChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        Optional<Object> unchangedSegment1;
        Log log = this.getLog();
        if (log != null && !this.allowIncrementalUpdates) {
            log.info((CharSequence)"Assuming allowMinorUpdates false because allowIncrementalUpdates is false.");
        }
        if (log != null && !this.allowMinorUpdates) {
            log.info((CharSequence)"Assuming allowMajorUpdates false because allowMinorUpdates is false.");
        }
        Optional<Object> optional = this.allowMajorUpdates && this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.empty() : (this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.of(Segment.MAJOR) : (unchangedSegment1 = this.allowIncrementalUpdates ? Optional.of(Segment.MINOR) : Optional.of(Segment.INCREMENTAL)));
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)(unchangedSegment1.map(Segment::minorTo).map(Segment::toString).orElse("ALL") + " version changes allowed"));
        }
        Optional<Object> unchangedSegment = unchangedSegment1;
        this.useLatestVersions(pom, dependencies, (dep, versions) -> {
            try {
                return versions.getNewestVersion(dep.getVersion(), unchangedSegment, this.allowSnapshots, this.allowDowngrade);
            }
            catch (InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s:%s due to: %s", dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), e.getMessage()));
                return Optional.empty();
            }
        }, changeKind, new Predicate[0]);
    }
}

