/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.versions.api.ReportRenderer;
import org.codehaus.mojo.versions.reporting.DependencyUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.ParentUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.PluginUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.PropertyUpdatesReportRenderer;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.ParentUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.plexus.i18n.I18N;

@Named
@Singleton
public class ReportRendererFactoryImpl
implements ReportRendererFactory {
    public static final String DEPENDENCY_UPDATES_REPORT = "dependency-updates-report";
    public static final String PLUGIN_UPDATES_REPORT = "plugin-updates-report";
    public static final String PROPERTY_UPDATES_REPORT = "property-updates-report";
    public static final String PARENT_UPDATES_REPORT = "parent-updates-report";
    private final I18N i18N;

    @Inject
    public ReportRendererFactoryImpl(I18N i18N) {
        this.i18N = i18N;
    }

    @Override
    public <T extends ReportRenderer, U> T createReportRenderer(String reportName, Sink sink, Locale locale, U model) throws IllegalArgumentException {
        if (DEPENDENCY_UPDATES_REPORT.equals(reportName)) {
            return (T)new DependencyUpdatesReportRenderer<DependencyUpdatesModel>(this.i18N, sink, locale, reportName, (DependencyUpdatesModel)model);
        }
        if (PLUGIN_UPDATES_REPORT.equals(reportName)) {
            return (T)new PluginUpdatesReportRenderer(this.i18N, sink, locale, reportName, (PluginUpdatesModel)model);
        }
        if (PROPERTY_UPDATES_REPORT.equals(reportName)) {
            return (T)new PropertyUpdatesReportRenderer(this.i18N, sink, locale, reportName, (PropertyUpdatesModel)model);
        }
        if (PARENT_UPDATES_REPORT.equals(reportName)) {
            return (T)new ParentUpdatesReportRenderer(this.i18N, sink, locale, reportName, (ParentUpdatesModel)model);
        }
        throw new IllegalArgumentException("Invalid report name: " + reportName);
    }
}

