/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.PluginOverviewStats;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.plexus.i18n.I18N;

public class PluginUpdatesReportRenderer
extends AbstractVersionsReportRenderer<PluginUpdatesModel> {
    public PluginUpdatesReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, PluginUpdatesModel model) {
        super(i18n, sink, locale, bundleName, model);
    }

    @Override
    protected void renderSummaryTable() {
        this.renderTable("report.overview.plugin", ((PluginUpdatesModel)this.model).getArtifactUpdates(), "report.overview.noPlugin");
    }

    @Override
    protected void renderManagementSummaryTable() {
        this.renderTable("report.overview.pluginManagement", ((PluginUpdatesModel)this.model).getArtifactManagementUpdates(), "report.overview.noPluginManagement");
    }

    @Override
    protected void renderDetails() {
        ((PluginUpdatesModel)this.model).getAllUpdates().forEach(this::renderPluginDetail);
    }

    private void renderDependencyDetail(Dependency dependency, ArtifactVersions details) {
        this.sink.section3();
        this.sink.sectionTitle3();
        this.sink.text(MessageFormat.format(this.getText("report.pluginDependency"), ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId())));
        this.sink.sectionTitle3_();
        this.renderDependencyDetailTable(dependency, details, false);
        this.sink.section3_();
    }

    private void renderTable(String titleKey, Map<Dependency, PluginUpdatesDetails> contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.renderSummaryTable(contents);
        }
        this.sink.section2_();
    }

    protected void renderSummaryTable(Map<Dependency, PluginUpdatesDetails> contents) {
        this.sink.table();
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        contents.forEach(this::renderSummaryTableRow);
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        this.sink.table_();
    }

    @Override
    protected PluginOverviewStats computeOverviewStats() {
        return (PluginOverviewStats)PluginOverviewStats.fromUpdates(((PluginUpdatesModel)this.model).getAllUpdates().values(), this.newestUpdateCache);
    }

    @Override
    protected void renderSummaryTableHeader(boolean hasScope, boolean hasType) {
        super.renderSummaryTableHeader(hasScope, hasType);
        this.renderTableHeaderCells("report.dependencyStatus");
    }

    @Override
    protected <T extends OverviewStats> void renderOverviewTableRow(T stats) {
        super.renderOverviewTableRow(stats);
        super.renderStatRow("report.overview.numNewerDependenciesAvailable", ((PluginOverviewStats)stats).getDependencies(), false);
    }

    protected void renderSummaryTableRow(Dependency artifact, PluginUpdatesDetails details) {
        boolean upToDate = !details.isUpdateAvailable();
        this.sink.tableRow();
        this.sink.tableCell();
        if (upToDate) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getGroupId());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(artifact.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableCell();
        if (!details.isArtifactUpdateAvailable()) {
            this.safeBold();
        }
        this.sink.text(artifact.getVersion());
        if (!details.isArtifactUpdateAvailable()) {
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (details.isDependencyUpdateAvailable()) {
            this.renderWarningIcon();
        } else {
            this.renderSuccessIcon();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    private void renderPluginDetail(Dependency artifact, PluginUpdatesDetails details) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(MessageFormat.format(this.getText("report.plugin"), ArtifactUtils.versionlessKey((String)details.getGroupId(), (String)details.getArtifactId())));
        this.sink.sectionTitle2_();
        this.renderPluginDetailTable(details);
        if (!details.getDependencyVersions().isEmpty()) {
            this.sink.section3();
            this.sink.sectionTitle3();
            this.sink.text(MessageFormat.format(this.getText("report.pluginDependencies"), ArtifactUtils.versionlessKey((String)details.getGroupId(), (String)details.getArtifactId())));
            this.sink.sectionTitle3_();
            this.renderSummaryTable(details.getDependencyVersions(), false);
            this.sink.section3_();
            details.getDependencyVersions().forEach(this::renderDependencyDetail);
        }
        this.sink.section2_();
    }

    private void renderPluginDetailTable(PluginUpdatesDetails details) {
        ArtifactVersion[] allUpdates = details.getAllUpdates(Optional.empty());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        SinkEventAttributeSet headerAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"70%");
        SinkEventAttributeSet cellAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"30%");
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        if (details.getNewestUpdate(Optional.of(Segment.SUBINCREMENTAL)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (details.getNewestUpdate(Optional.of(Segment.INCREMENTAL)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (details.getNewestUpdate(Optional.of(Segment.MINOR)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (details.getNewestUpdate(Optional.of(Segment.MAJOR)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.groupId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(details.getGroupId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.artifactId"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(details.getArtifactId());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(details.getVersion());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (!upToDate) {
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.updateVersions"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            for (int i = 0; i < allUpdates.length; ++i) {
                String label;
                if (i > 0) {
                    this.sink.lineBreak();
                }
                if ((label = this.getLabel(allUpdates[i], details)) != null) {
                    this.safeBold();
                }
                this.sink.text(allUpdates[i].toString());
                if (label == null) continue;
                this.safeBold_();
                this.sink.nonBreakingSpace();
                this.safeItalic();
                this.sink.text(label);
                this.safeItalic_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRows_();
        this.sink.table_();
    }
}

