/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Embedded;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tomcat.AbstractRunMojo;
import org.codehaus.plexus.util.StringUtils;

public class RunMojo
extends AbstractRunMojo {
    private File classesDir;
    private Set<Artifact> dependencies;
    private File warSourceDirectory;
    private File contextFile;
    private boolean delegate = true;

    protected Context createContext(Embedded container) throws IOException, MojoExecutionException {
        Context context = super.createContext(container);
        context.setReloadable(true);
        return context;
    }

    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        WebappLoader loader = super.createWebappLoader();
        if (this.useSeparateTomcatClassLoader) {
            loader.setDelegate(this.delegate);
        }
        if (this.classesDir != null) {
            try {
                List classPathElements = this.project.getCompileClasspathElements();
                for (String classPathElement : classPathElements) {
                    File classPathElementFile = new File(classPathElement);
                    if (!classPathElementFile.exists() || !classPathElementFile.isDirectory()) continue;
                    this.getLog().debug((CharSequence)("adding classPathElementFile " + classPathElementFile.toURI().toString()));
                    loader.addRepository(classPathElementFile.toURI().toString());
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        if (this.dependencies != null) {
            for (Artifact artifact : this.dependencies) {
                String scope = artifact.getScope();
                if ("provided".equals(scope) || "test".equals(scope)) continue;
                this.getLog().debug((CharSequence)("add dependency to webapploader " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getScope()));
                if (!this.isInProjectReferences(artifact)) {
                    loader.addRepository(artifact.getFile().toURI().toString());
                    continue;
                }
                this.getLog().debug((CharSequence)("skip adding artifact " + artifact.getArtifactId() + " as it's in reactors"));
            }
        }
        return loader;
    }

    protected boolean isInProjectReferences(Artifact artifact) {
        if (this.project.getProjectReferences() == null || this.project.getProjectReferences().isEmpty()) {
            return false;
        }
        Collection mavenProjects = this.project.getProjectReferences().values();
        for (MavenProject mavenProject : mavenProjects) {
            if (!StringUtils.equals((String)mavenProject.getId(), (String)artifact.getId())) continue;
            return true;
        }
        return false;
    }

    protected File getDocBase() {
        return this.warSourceDirectory;
    }

    protected File getContextFile() {
        return this.contextFile;
    }
}

