/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.properties.AbstractWritePropertiesMojo;
import org.codehaus.mojo.properties.managers.PropertiesManager;

@Mojo(name="write-project-properties", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class WriteProjectProperties
extends AbstractWritePropertiesMojo {
    @Parameter(property="properties.excludedPropertyKeys")
    private Set<String> excludedPropertyKeys;
    @Parameter(property="properties.includedPropertyKeys")
    private Set<String> includedPropertyKeys;

    @Inject
    protected WriteProjectProperties(List<PropertiesManager> propertiesManagers) {
        super(propertiesManagers);
    }

    public void execute() throws MojoExecutionException {
        this.validateOutputFile();
        Properties projProperties = new Properties();
        projProperties.putAll((Map<?, ?>)this.getProject().getProperties());
        Properties systemProperties = System.getProperties();
        Enumeration<Object> enumeration = systemProperties.keys();
        while (enumeration.hasMoreElements()) {
            String key2 = (String)enumeration.nextElement();
            String value = systemProperties.getProperty(key2);
            if (projProperties.get(key2) == null) continue;
            projProperties.put(key2, value);
        }
        Optional.ofNullable(this.excludedPropertyKeys).orElseGet(Collections::emptySet).forEach(projProperties::remove);
        if (this.includedPropertyKeys != null && !this.includedPropertyKeys.isEmpty()) {
            projProperties.keySet().removeIf(key -> !this.includedPropertyKeys.contains(String.valueOf(key)));
        }
        this.writeProperties(projProperties);
    }

    void setExcludedPropertyKeys(Set<String> excludedPropertyKeys) {
        this.excludedPropertyKeys = excludedPropertyKeys;
    }

    void setIncludedPropertyKeys(Set<String> includedPropertyKeys) {
        this.includedPropertyKeys = includedPropertyKeys;
    }
}

