/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.mojo.properties.managers.PropertiesManager;

public abstract class AbstractPropertiesMojo
extends AbstractMojo {
    private final List<PropertiesManager> propertiesManagers;

    protected AbstractPropertiesMojo(List<PropertiesManager> propertiesManagers) {
        this.propertiesManagers = propertiesManagers;
    }

    protected PropertiesManager getPropertiesManager(String resourceExtension) {
        this.getLog().debug((CharSequence)("Available properties managers: " + this.propertiesManagers));
        String resourceExtensionLowerCase = resourceExtension.toLowerCase(Locale.ROOT);
        Optional<PropertiesManager> propertiesStore = this.propertiesManagers.stream().filter(manager -> manager.isExtensionSupport(resourceExtensionLowerCase)).findFirst();
        if (!propertiesStore.isPresent()) {
            this.getLog().warn((CharSequence)("Unknown properties resource extension: '" + resourceExtension + "' assume as: '" + "properties" + "'"));
            return this.getDefaultPropertiesManager();
        }
        return propertiesStore.get();
    }

    private PropertiesManager getDefaultPropertiesManager() {
        return this.propertiesManagers.stream().filter(manager -> manager.isExtensionSupport("properties")).findFirst().orElseThrow(() -> new RuntimeException("Default properties manager not exist"));
    }
}

