/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class CircularDefinitionPreventer {
    private final List<VisitedProperty> entriesVisited = new LinkedList<VisitedProperty>();
    private final Set<String> keysUsed = new HashSet<String>();

    CircularDefinitionPreventer() {
    }

    public CircularDefinitionPreventer visited(String key, String value) {
        this.entriesVisited.add(new VisitedProperty(key, value));
        if (this.keysUsed.contains(key) && !this.isValueResolved(value)) {
            this.circularDefinition();
        } else {
            this.keysUsed.add(key);
        }
        return this;
    }

    private void circularDefinition() {
        StringBuilder buffer = new StringBuilder("Circular property definition: ");
        Iterator<VisitedProperty> iterator = this.entriesVisited.iterator();
        while (iterator.hasNext()) {
            VisitedProperty visited = iterator.next();
            buffer.append(visited.key).append("=").append(visited.value);
            if (!iterator.hasNext()) continue;
            buffer.append(" -> ");
        }
        throw new IllegalArgumentException(buffer.toString());
    }

    private boolean isValueResolved(String value) {
        int prefixPos = value.indexOf("${");
        int suffixPos = value.indexOf("}");
        return prefixPos < 0 || suffixPos <= prefixPos;
    }

    private static class VisitedProperty {
        private final String key;
        private final String value;

        private VisitedProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

