/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.bcc;

import java.io.File;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.c.CLinker;
import org.codehaus.mojo.natives.linker.Linker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

@Component(role=Linker.class, hint="bcc", instantiationStrategy="per-lookup")
public class BCCLinker
extends CLinker {
    public static final String DEFAULT_EXECUTABLE = "ilink32";

    protected Commandline createLinkerCommandLine(List objectFiles, LinkerConfiguration config) throws NativeBuildException {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        String executable = DEFAULT_EXECUTABLE;
        if (config.getExecutable() != null && config.getExecutable().trim().length() != 0) {
            executable = config.getExecutable();
        }
        cl.createArg().setValue(executable);
        cl.addArguments(config.getStartOptions());
        for (int i = 0; i < objectFiles.size(); ++i) {
            File objFile = (File)objectFiles.get(i);
            cl.createArg().setValue(objFile.getPath());
        }
        for (String fileName : config.getExternalLibFileNames()) {
            if (FileUtils.getExtension((String)fileName).toLowerCase().equals("res")) continue;
            cl.createArg().setFile(new File(config.getExternalLibDirectory(), fileName));
        }
        cl.createArg().setValue("," + config.getOutputFile());
        cl.createArg().setValue(",");
        cl.addArguments(config.getMiddleOptions());
        cl.createArg().setValue(",");
        for (String fileName : config.getExternalLibFileNames()) {
            if (!FileUtils.getExtension((String)fileName).toLowerCase().equals("res")) continue;
            cl.createArg().setFile(new File(config.getExternalLibDirectory(), fileName));
        }
        return cl;
    }
}

