/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.bcc;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.EnvFactory;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.util.EnvUtil;

public class BCCEnvFactory
implements EnvFactory {
    private static final String BCC_INSTALL_ENV_KEY = "BCC_INSTALL_DIR";
    private static final String DEFAULT_BCC_INSTALL_DIR = "C:/Borland/BCC";
    private static Map<String, String> envs;

    public synchronized Map<String, String> getEnvironmentVariables() throws NativeBuildException {
        if (envs == null) {
            envs = this.createEnvs();
        }
        return envs;
    }

    private Map<String, String> createEnvs() throws NativeBuildException {
        File bccDir = new File(EnvUtil.getEnv((String)BCC_INSTALL_ENV_KEY, (String)BCC_INSTALL_ENV_KEY, (String)DEFAULT_BCC_INSTALL_DIR));
        if (!bccDir.isDirectory()) {
            throw new NativeBuildException(bccDir.getPath() + " is not a directory.");
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        String currentPath = System.getProperty("java.library.path");
        String newPath = bccDir.getPath() + "\\BIN;" + currentPath;
        envs.put("PATH", newPath);
        return envs;
    }
}

