/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.SourceDependencyAnalyzer;
import org.codehaus.mojo.natives.compiler.ResourceCompiler;
import org.codehaus.mojo.natives.compiler.ResourceCompilerConfiguration;
import org.codehaus.mojo.natives.parser.CParser;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.mojo.natives.util.EnvUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractResourceCompiler
extends AbstractLogEnabled
implements ResourceCompiler {
    protected abstract Commandline getCommandLine(ResourceCompilerConfiguration var1, File var2) throws NativeBuildException;

    @Override
    public List compile(ResourceCompilerConfiguration config, NativeSources[] sources) throws NativeBuildException {
        File[] sourceFiles = NativeSources.getAllSourceFiles(sources);
        config.setIncludePaths(NativeSources.getIncludePaths(sources));
        config.setSystemIncludePaths(NativeSources.getSystemIncludePaths(sources));
        ArrayList<File> compilerOutputFiles = new ArrayList<File>(sourceFiles.length);
        for (int i = 0; i < sourceFiles.length; ++i) {
            File src = sourceFiles[i];
            if (!"rc".equals(FileUtils.getExtension((String)src.getPath()))) continue;
            File outputFile = config.getOutputFile(src);
            compilerOutputFiles.add(outputFile);
            if (!this.isResourceFileStaled(src, outputFile, config.getIncludePaths())) continue;
            Commandline cl = this.getCommandLine(config, src);
            EnvUtil.setupCommandlineEnv(cl, config.getEnvFactory());
            CommandLineUtil.execute(cl, this.getLogger());
        }
        return compilerOutputFiles;
    }

    private boolean isResourceFileStaled(File src, File dest, File[] includePaths) throws NativeBuildException {
        CParser parser = new CParser();
        try {
            if (!SourceDependencyAnalyzer.isStaled(src, dest, parser, includePaths)) {
                this.getLogger().info(src.getPath() + " is up to date.");
                return false;
            }
        }
        catch (NativeBuildException ioe) {
            throw new NativeBuildException("Error analyzing " + src.getPath() + " dependencies.", ioe);
        }
        return true;
    }
}

