/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.javah.Javah;
import org.codehaus.mojo.natives.javah.JavahConfiguration;
import org.codehaus.mojo.natives.manager.JavahManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.mojo.natives.plugin.JavahInclude;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="javah", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NativeJavahMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="default", required=true)
    private String javahProvider;
    @Parameter
    private List javahClassNames = new ArrayList(0);
    @Parameter(defaultValue="false")
    private boolean javahSearchJNIFromDependencies;
    @Parameter
    private File javahPath;
    @Parameter(defaultValue="${project.build.directory}/native/javah", required=true)
    protected File javahOutputDirectory;
    @Parameter
    private String javahOutputFileName;
    @Parameter
    private List javahIncludes = new ArrayList();
    @Parameter(defaultValue="false")
    private boolean javahVerbose;
    @Parameter(defaultValue="false")
    private boolean attach;
    @Parameter(defaultValue="javah")
    private String classifier;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.inczip", required=true)
    private File incZipFile;
    @Parameter(defaultValue="false")
    private boolean useEnvClasspath;
    @Component
    private JavahManager manager;
    @Component
    private MavenProjectHelper projectHelper;
    private JavahConfiguration config;

    public void execute() throws MojoExecutionException {
        this.discoverAdditionalJNIClassName();
        if (this.javahClassNames.size() == 0 && this.javahIncludes.size() == 0) {
            return;
        }
        try {
            if (this.javahClassNames.size() != 0) {
                this.config = this.createProviderConfiguration(this.javahClassNames.toArray(new String[this.javahClassNames.size()]), this.javahOutputFileName);
                this.getJavah().compile(this.config);
            }
            for (int i = 0; i < this.javahIncludes.size(); ++i) {
                JavahInclude javahInclude = (JavahInclude)this.javahIncludes.get(i);
                this.config = this.createProviderConfiguration(new String[]{javahInclude.getClassName()}, javahInclude.getHeaderName());
                this.getJavah().compile(this.config);
            }
            if (this.attach) {
                this.attachGeneratedIncludeFilesAsIncZip();
            }
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException("Error running javah command", (Exception)((Object)e));
        }
        this.project.addCompileSourceRoot(this.javahOutputDirectory.getAbsolutePath());
    }

    private void attachGeneratedIncludeFilesAsIncZip() throws MojoExecutionException {
        try {
            ZipArchiver archiver = new ZipArchiver();
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setUsingDefaultExcludes(true);
            fileSet.setDirectory(this.javahOutputDirectory);
            archiver.addFileSet((FileSet)fileSet);
            archiver.setDestFile(this.incZipFile);
            archiver.createArchive();
            if (StringUtils.isBlank((String)this.classifier)) {
                this.projectHelper.attachArtifact(this.project, "inczip", null, this.incZipFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "inczip", this.classifier, this.incZipFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to archive/deploy generated include files", e);
        }
    }

    private Javah getJavah() throws MojoExecutionException {
        Javah javah;
        try {
            javah = this.manager.getJavah(this.javahProvider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return javah;
    }

    private List getJavahArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        List artifacts = this.project.getCompileArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!"jar".equals(artifact.getType()) || "provided".equals(artifact.getScope())) continue;
                list.add(artifact);
            }
        }
        return list;
    }

    private String[] getJavahClassPath() {
        List artifacts = this.getJavahArtifacts();
        String[] classPaths = new String[artifacts.size() + 1];
        classPaths[0] = this.project.getBuild().getOutputDirectory();
        Iterator iter = artifacts.iterator();
        for (int i = 1; i < classPaths.length; ++i) {
            Artifact artifact = (Artifact)iter.next();
            classPaths[i] = artifact.getFile().getPath();
        }
        return classPaths;
    }

    private void discoverAdditionalJNIClassName() throws MojoExecutionException {
        if (!this.javahSearchJNIFromDependencies) {
            return;
        }
        List artifacts = this.getJavahArtifacts();
        for (Artifact artifact : artifacts) {
            this.getLog().info((CharSequence)("Parsing " + artifact.getFile() + " for native classes."));
            try {
                ZipFile zipFile = new ZipFile(artifact.getFile());
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                block3: while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    if (!"class".equals(FileUtils.extension((String)zipEntry.getName()))) continue;
                    ClassParser parser = new ClassParser(artifact.getFile().getPath(), zipEntry.getName());
                    JavaClass clazz = parser.parse();
                    Method[] methods = clazz.getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        if (!methods[j].isNative()) continue;
                        this.javahClassNames.add(clazz.getClassName());
                        this.getLog().info((CharSequence)("Found native class: " + clazz.getClassName()));
                        continue block3;
                    }
                }
                zipFile.close();
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Error searching for native class in " + artifact.getFile(), (Exception)ioe);
            }
        }
    }

    private JavahConfiguration createProviderConfiguration(String[] classNames, String javahOutputFileName) throws MojoExecutionException {
        JavahConfiguration config = new JavahConfiguration();
        config.setWorkingDirectory(this.workingDirectory);
        config.setVerbose(this.javahVerbose);
        config.setOutputDirectory(this.javahOutputDirectory);
        config.setFileName(javahOutputFileName);
        config.setClassPaths(this.getJavahClassPath());
        config.setUseEnvClasspath(this.useEnvClasspath);
        config.setClassNames(classNames);
        config.setJavahPath(this.javahPath);
        return config;
    }

    protected JavahConfiguration getJavahConfiguration() {
        return this.config;
    }

    @Override
    protected MavenProject getProject() {
        return this.project;
    }
}

