/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.impl.maven.MockArtifactStore;
import org.codehaus.mojo.mrm.plugin.ArtifactStoreFactory;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;

@Named(value="mockRepo")
@Singleton
public class MockRepo
implements ArtifactStoreFactory {
    @Inject
    private FactoryHelper factoryHelper;
    private File source;
    private File cloneTo;
    private boolean cloneClean;
    private boolean lazyArchiver;

    public ArtifactStore newInstance(MavenSession session, Log log) {
        Objects.requireNonNull(this.factoryHelper, "FactoryHelper has not been set");
        if (this.source == null) {
            throw new IllegalStateException("Must provide the 'source' of the mock repository");
        }
        File root = this.source;
        if (this.cloneTo != null) {
            if (!this.cloneTo.mkdirs() && this.cloneClean) {
                try {
                    FileUtils.cleanDirectory((File)this.cloneTo);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to clean directory: " + e.getMessage());
                }
            }
            try {
                FileUtils.copyDirectory((File)this.source, (File)this.cloneTo);
                root = this.cloneTo;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to copy directory: " + e.getMessage());
            }
        }
        return new MockArtifactStore(log, root, this.lazyArchiver);
    }

    public void setFactoryHelper(FactoryHelper factoryHelper) {
        this.factoryHelper = factoryHelper;
    }

    public String toString() {
        return "Mock content (source: " + this.source + ')';
    }
}

