/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.impl.digest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.BaseFileEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.digest.BaseDigestFileEntryFactory;

public class SHA1DigestFileEntry
extends BaseFileEntry {
    private final FileEntry entry;

    public SHA1DigestFileEntry(FileSystem fileSystem, DirectoryEntry parent, FileEntry entry) {
        super(fileSystem, parent, entry.getName() + ".sha1");
        this.entry = entry;
    }

    public long getLastModified() throws IOException {
        return this.entry.getLastModified();
    }

    public long getSize() throws IOException {
        return 40L;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }

    private byte[] getContent() throws IOException {
        byte[] byArray;
        block9: {
            InputStream is = this.entry.getInputStream();
            try {
                int read;
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                digest.reset();
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                String md5 = StringUtils.leftPad((String)new BigInteger(1, digest.digest()).toString(16), (int)40, (String)"0");
                byArray = md5.getBytes();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Unable to calculate hash", e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static class Factory
    extends BaseDigestFileEntryFactory {
        @Override
        public String getType() {
            return ".sha1";
        }

        @Override
        public FileEntry create(FileSystem fileSystem, DirectoryEntry parent, FileEntry entry) {
            return new SHA1DigestFileEntry(fileSystem, parent, entry);
        }
    }
}

