/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import javax.servlet.Servlet;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.plugin.ServerLogger;
import org.codehaus.mojo.mrm.servlet.FileSystemServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FileSystemServer {
    private final Object lock = new Object();
    private boolean starting = false;
    private boolean started = false;
    private boolean finished = false;
    private boolean finishing = false;
    private int boundPort = 0;
    private Exception problem = null;
    private final String name;
    private final FileSystem fileSystem;
    private final int requestedPort;
    private final String contextPath;
    private final boolean debugServer;

    public FileSystemServer(String name, int port, String contextPath, FileSystem fileSystem, boolean debugServer) {
        this.name = name;
        this.fileSystem = fileSystem;
        this.requestedPort = port;
        this.contextPath = FileSystemServer.sanitizeContextPath(contextPath);
        this.debugServer = debugServer;
    }

    static String sanitizeContextPath(String contextPath) {
        if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
            return "/";
        }
        if (!contextPath.startsWith("/")) {
            return "/" + contextPath;
        }
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureStarted() throws MojoExecutionException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started || this.starting) {
                return;
            }
            this.starting = true;
            this.started = false;
            this.finished = false;
            this.finishing = false;
        }
        Thread worker = new Thread((Runnable)new Worker(), "FileSystemServer[" + this.name + "]");
        worker.setDaemon(true);
        worker.start();
        try {
            Object object2 = this.lock;
            synchronized (object2) {
                while (this.starting && !this.started && !this.finished && !this.finishing) {
                    this.lock.wait();
                }
                if (this.problem != null) {
                    throw this.problem;
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.lock;
        synchronized (object) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.lock;
        synchronized (object) {
            this.finishing = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinished() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.finished) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            return this.started ? this.boundPort : this.requestedPort;
        }
    }

    public String getUrl() {
        return "http://localhost:" + this.getPort() + (this.contextPath.equals("/") ? "" : this.contextPath);
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServerLogger serverLogger = new ServerLogger(FileSystemServer.this.debugServer);
                Log.setLog((Logger)serverLogger);
                Log.initialized();
                Server server = new Server(FileSystemServer.this.requestedPort);
                try {
                    ServletContextHandler context = new ServletContextHandler();
                    context.setContextPath(FileSystemServer.this.contextPath);
                    context.addServlet(new ServletHolder((Servlet)new FileSystemServlet(FileSystemServer.this.fileSystem)), "/*");
                    server.setHandler((Handler)context);
                    server.start();
                    Object object = FileSystemServer.this.lock;
                    synchronized (object) {
                        FileSystemServer.this.boundPort = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
                        FileSystemServer.this.starting = false;
                        FileSystemServer.this.started = true;
                        FileSystemServer.this.lock.notifyAll();
                    }
                }
                catch (Exception e) {
                    Object object = FileSystemServer.this.lock;
                    synchronized (object) {
                        FileSystemServer.this.problem = e;
                    }
                    serverLogger.warn(e);
                    throw e;
                }
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    while (!FileSystemServer.this.finishing) {
                        try {
                            FileSystemServer.this.lock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                server.stop();
                server.join();
            }
            catch (Exception exception) {
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    FileSystemServer.this.started = false;
                    FileSystemServer.this.starting = false;
                    FileSystemServer.this.finishing = false;
                    FileSystemServer.this.finished = true;
                    FileSystemServer.this.boundPort = 0;
                    FileSystemServer.this.lock.notifyAll();
                }
            }
            finally {
                Object object = FileSystemServer.this.lock;
                synchronized (object) {
                    FileSystemServer.this.started = false;
                    FileSystemServer.this.starting = false;
                    FileSystemServer.this.finishing = false;
                    FileSystemServer.this.finished = true;
                    FileSystemServer.this.boundPort = 0;
                    FileSystemServer.this.lock.notifyAll();
                }
            }
        }
    }
}

