/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.api.maven.ArtifactStore;
import org.codehaus.mojo.mrm.impl.digest.AutoDigestFileSystem;
import org.codehaus.mojo.mrm.impl.maven.ArtifactStoreFileSystem;
import org.codehaus.mojo.mrm.impl.maven.CompositeArtifactStore;
import org.codehaus.mojo.mrm.plugin.AbstractMRMMojo;
import org.codehaus.mojo.mrm.plugin.ArtifactStoreFactory;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;
import org.codehaus.mojo.mrm.plugin.FileSystemServer;

public abstract class AbstractStartMojo
extends AbstractMRMMojo {
    private final FactoryHelper factoryHelper;
    @Parameter(property="mrm.port")
    private int port;
    @Parameter(property="mrm.basePath", defaultValue="/")
    private String basePath;
    @Parameter
    private ArtifactStoreFactory[] repositories;
    @Parameter(property="mrm.debugServer", defaultValue="false")
    private boolean debugServer;

    protected AbstractStartMojo(FactoryHelper factoryHelper, ArtifactStoreFactory proxyRepo) {
        super(proxyRepo);
        this.factoryHelper = factoryHelper;
    }

    protected FileSystemServer createFileSystemServer(ArtifactStore artifactStore) {
        return new FileSystemServer(ArtifactUtils.versionlessKey((String)this.project.getGroupId(), (String)this.project.getArtifactId()), Math.max(0, Math.min(this.port, 65535)), this.basePath, (FileSystem)new AutoDigestFileSystem((FileSystem)new ArtifactStoreFileSystem(artifactStore)), this.debugServer);
    }

    protected ArtifactStore createArtifactStore() throws MojoExecutionException {
        Objects.requireNonNull(this.proxyRepo);
        if (this.repositories == null) {
            this.getLog().info((CharSequence)"Configuring Mock Repository Manager to proxy through this Maven instance");
            return this.createProxyArtifactStore();
        }
        this.getLog().info((CharSequence)"Configuring Mock Repository Manager...");
        ArrayList<ArtifactStore> stores = new ArrayList<ArtifactStore>();
        if (this.repositories == null || this.repositories.length == 0) {
            this.repositories = new ArtifactStoreFactory[]{this.proxyRepo};
        }
        for (ArtifactStoreFactory artifactStoreFactory : this.repositories) {
            this.getLog().info((CharSequence)("  " + artifactStoreFactory.toString()));
            if (artifactStoreFactory != this.proxyRepo) {
                artifactStoreFactory.setFactoryHelper(this.factoryHelper);
            }
            stores.add(artifactStoreFactory.newInstance(this.session, this.getLog()));
        }
        ArtifactStore[] artifactStores = stores.toArray(new ArtifactStore[0]);
        return artifactStores.length == 1 ? artifactStores[0] : new CompositeArtifactStore(artifactStores);
    }
}

