/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.api;

import java.util.Objects;
import java.util.Stack;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileSystem;

public abstract class AbstractEntry
implements Entry {
    private final FileSystem fileSystem;
    private final DirectoryEntry parent;
    private final String name;

    protected AbstractEntry(FileSystem fileSystem, DirectoryEntry parent, String name) {
        this.fileSystem = fileSystem;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public DirectoryEntry getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractEntry)) {
            return false;
        }
        AbstractEntry abstractEntry = (AbstractEntry)o;
        if (!this.fileSystem.equals(abstractEntry.fileSystem)) {
            return false;
        }
        if (!this.name.equals(abstractEntry.name)) {
            return false;
        }
        return Objects.equals(this.parent, abstractEntry.parent);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry[");
        sb.append(this.fileSystem);
        sb.append(':').append(this.toPath()).append(']');
        return sb.toString();
    }

    @Override
    public final String toPath() {
        Stack<String> stack = new Stack<String>();
        DirectoryEntry root = this.getFileSystem().getRoot();
        Entry entry = this;
        do {
            stack.push(entry.getName());
        } while ((entry = entry.getParent()) != null && !root.equals(entry));
        StringBuilder buf = new StringBuilder();
        while (stack.size() > 1) {
            buf.append((String)stack.pop());
            buf.append('/');
        }
        buf.append((String)stack.pop());
        return buf.toString();
    }
}

