/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Scm;
import org.codehaus.mojo.license.download.License;
import org.codehaus.mojo.license.extended.ExtendedInfo;
import org.codehaus.mojo.license.extended.InfoFile;
import org.codehaus.mojo.license.spdx.SpdxLicenseInfo;
import org.codehaus.mojo.license.spdx.SpdxLicenseList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensedArtifact {
    private static final Logger LOG = LoggerFactory.getLogger(LicensedArtifact.class);
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final List<License> licenses;
    private final List<String> errorMessages;
    private final ExtendedInfo extendedInfos;

    public static Builder builder(Artifact artifact, boolean useNonMavenData) {
        return new Builder(artifact, useNonMavenData);
    }

    LicensedArtifact(String groupId, String artifactId, String version, List<License> licenses, List<String> errorMessages, ExtendedInfo extendedInfos) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.licenses = licenses;
        this.errorMessages = errorMessages;
        this.extendedInfos = extendedInfos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.licenses == null ? 0 : this.licenses.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LicensedArtifact other = (LicensedArtifact)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.licenses == null ? other.licenses != null : !this.licenses.equals(other.licenses)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public ExtendedInfo getExtendedInfos() {
        return this.extendedInfos;
    }

    public static class Builder {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private List<License> licenses = new ArrayList<License>();
        private List<String> errorMessages = new ArrayList<String>();
        private final ExtendedInfo extendedInfos;

        public Builder(Artifact artifact, boolean useNonMavenData) {
            this.groupId = artifact.getGroupId();
            this.artifactId = artifact.getArtifactId();
            this.version = artifact.getVersion();
            this.extendedInfos = useNonMavenData ? this.extraInfosFromArtifact(artifact) : null;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessages.add(errorMessage);
            return this;
        }

        public Builder license(License license) {
            this.licenses.add(license);
            return this;
        }

        public LicensedArtifact build() {
            List<License> lics = Collections.unmodifiableList(this.licenses);
            this.licenses = null;
            List<String> msgs = Collections.unmodifiableList(this.errorMessages);
            this.errorMessages = null;
            return new LicensedArtifact(this.groupId, this.artifactId, this.version, lics, msgs, this.extendedInfos);
        }

        private ExtendedInfo extraInfosFromArtifact(Artifact artifact) {
            if (artifact.getFile() == null) {
                LOG.error("Artifact " + artifact + " has no valid file set");
                return null;
            }
            ExtendedInfo result = new ExtendedInfo();
            result.setArtifact(artifact);
            try (ZipFile zipFile = new ZipFile(artifact.getFile());){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    InfoFile infoFile;
                    ZipEntry zipEntry = entries.nextElement();
                    String fileName = zipEntry.getName().toLowerCase();
                    if (this.textFileMatcher(fileName, "notice")) {
                        infoFile = this.buildInfoFile(zipFile, zipEntry, InfoFile.Type.NOTICE);
                        result.getInfoFiles().add(infoFile);
                        continue;
                    }
                    if (this.textFileMatcher(fileName, "license", "licence")) {
                        infoFile = this.buildInfoFile(zipFile, zipEntry, InfoFile.Type.LICENSE);
                        result.getInfoFiles().add(infoFile);
                        continue;
                    }
                    if (this.fileMatchesSpdxId(fileName)) {
                        infoFile = this.buildInfoFile(zipFile, zipEntry, InfoFile.Type.SPDX_LICENSE);
                        result.getInfoFiles().add(infoFile);
                        continue;
                    }
                    if (!fileName.equals("meta-inf/manifest.mf")) continue;
                    try {
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        try {
                            Manifest manifest = new Manifest(inputStream);
                            Attributes mainAttributes = manifest.getMainAttributes();
                            Object implementationVendor = mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
                            if (implementationVendor instanceof String) {
                                result.setImplementationVendor((String)implementationVendor);
                            }
                            String bundleVendor = mainAttributes.getValue("Bundle-Vendor");
                            result.setBundleVendor(bundleVendor);
                            String bundleLicense = mainAttributes.getValue("Bundle-License");
                            result.setBundleLicense(bundleLicense);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Error at reading data from jar manifest", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Can't open zip file \"" + artifact.getFile() + "\"", (Throwable)e);
            }
            return result;
        }

        private InfoFile buildInfoFile(ZipFile zipFile, ZipEntry zipEntry, InfoFile.Type type) {
            InfoFile infoFile = new InfoFile();
            infoFile.setFileName(zipEntry.getName());
            infoFile.setType(type);
            Pair<String, String[]> contentWithLines = this.readZipEntryTextLines(zipFile, zipEntry);
            if (contentWithLines != null) {
                Set<String> copyrights = this.scanForCopyrights((String[])contentWithLines.getRight(), "(c)", "copyright");
                if (!CollectionUtils.isEmpty(copyrights)) {
                    infoFile.getExtractedCopyrightLines().addAll(copyrights);
                }
                infoFile.setContent((String)contentWithLines.getLeft());
            }
            return infoFile;
        }

        private boolean fileMatchesSpdxId(String fileName) {
            SpdxLicenseList spdxList = SpdxLicenseList.getLatest();
            for (Map.Entry<String, SpdxLicenseInfo> entry : spdxList.getLicenses().entrySet()) {
                if (!this.textFileMatcher(fileName, entry.getValue().getLicenseId().toLowerCase())) continue;
                return true;
            }
            return false;
        }

        private boolean textFileMatcher(String fileName, String ... matchStrings) {
            for (String matchString : matchStrings) {
                if (!fileName.matches(".*" + matchString + ".*\\.txt")) continue;
                return true;
            }
            return false;
        }

        private Set<String> scanForCopyrights(String[] lines, String ... copyrightMatchers) {
            if (lines == null) {
                return null;
            }
            HashSet<String> result = new HashSet<String>();
            for (String line : lines) {
                for (String copyrightMatcher : copyrightMatchers) {
                    String trimmedLine = line.trim();
                    if (!trimmedLine.toLowerCase().contains(copyrightMatcher)) continue;
                    result.add(trimmedLine);
                }
            }
            return result;
        }

        private Pair<String, String[]> readZipEntryTextLines(ZipFile zipFile, ZipEntry zipEntry) {
            ImmutablePair immutablePair;
            block8: {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    byte[] content = IOUtils.readFully((InputStream)inputStream, (int)((int)zipEntry.getSize()));
                    String contentString = new String(content);
                    immutablePair = new ImmutablePair((Object)contentString, (Object)contentString.split("\\R+"));
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.warn("Can't read zip file entry " + zipEntry, (Throwable)e);
                        return null;
                    }
                }
                inputStream.close();
            }
            return immutablePair;
        }

        public void setInceptionYear(String inceptionYear) {
            if (this.extendedInfos != null) {
                this.extendedInfos.setInceptionYear(inceptionYear);
            }
        }

        public void setOrganization(Organization organization) {
            if (this.extendedInfos != null) {
                this.extendedInfos.setOrganization(organization);
            }
        }

        public void setDevelopers(List<Developer> developers) {
            if (this.extendedInfos != null) {
                this.extendedInfos.setDevelopers(developers);
            }
        }

        public void setUrl(String url) {
            if (this.extendedInfos != null) {
                this.extendedInfos.setUrl(url);
            }
        }

        public void setScm(Scm scm) {
            if (this.extendedInfos != null) {
                this.extendedInfos.setScm(scm);
            }
        }

        public void setName(String name) {
            if (this.extendedInfos != null) {
                this.extendedInfos.setName(name);
            }
        }
    }
}

