/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.model.LicenseRepository;
import org.codehaus.mojo.license.model.RootPackageClassPathLicenseRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseStore
implements Iterable<LicenseRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseStore.class);
    public static final String JAR_LICENSE_REPOSITORY = "/META-INF/licenses";
    public static final String CLASSPATH_PROTOCOL = "classpath://";
    protected List<LicenseRepository> repositories;
    protected boolean init;

    public static LicenseStore createLicenseStore(String ... extraResolver) throws MojoExecutionException {
        LicenseStore store;
        try {
            store = new LicenseStore();
            store.addJarRepository();
            if (extraResolver != null) {
                for (String s : extraResolver) {
                    if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                    LOG.info("adding extra resolver {}", (Object)s);
                    store.addRepository(s);
                }
            }
            store.init();
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("could not obtain the license repository", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not obtain the license repository", (Exception)ex);
        }
        return store;
    }

    public void init() throws IOException {
        this.checkNotInit("init");
        try {
            if (this.repositories == null) {
                this.addJarRepository();
            }
            for (LicenseRepository r : this) {
                r.load();
            }
        }
        finally {
            this.init = true;
        }
    }

    public List<LicenseRepository> getRepositories() {
        return this.repositories;
    }

    public String[] getLicenseNames() {
        this.checkInit("getLicenseNames");
        ArrayList<String> result = new ArrayList<String>();
        for (LicenseRepository repository : this) {
            for (License license : repository) {
                result.add(license.getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public License[] getLicenses() {
        this.checkInit("getLicenses");
        ArrayList<License> result = new ArrayList<License>();
        if (this.repositories != null) {
            for (LicenseRepository repository : this) {
                for (License license : repository) {
                    result.add(license);
                }
            }
        }
        return result.toArray(new License[result.size()]);
    }

    public License getLicense(String licenseName) {
        this.checkInit("getLicense");
        Iterator<LicenseRepository> itr = this.iterator();
        License result = null;
        while (itr.hasNext()) {
            LicenseRepository licenseRepository = itr.next();
            License license = licenseRepository.getLicense(licenseName);
            if (license == null) continue;
            result = license;
            break;
        }
        if (result == null) {
            LOG.debug("could not find license named '{}'", (Object)licenseName);
        }
        return result;
    }

    public void addRepository(String extraResolver) throws IOException {
        if (extraResolver.equals(CLASSPATH_PROTOCOL)) {
            this.addRootPackageClassPathRepository();
        } else if (extraResolver.startsWith(CLASSPATH_PROTOCOL)) {
            extraResolver = extraResolver.substring(CLASSPATH_PROTOCOL.length());
            LOG.debug("Using classpath extraresolver: {}", (Object)extraResolver);
            URL baseURL = this.getClass().getClassLoader().getResource(extraResolver);
            this.addRepository(baseURL);
        } else {
            URL baseURL = new URL(extraResolver);
            this.addRepository(baseURL);
        }
    }

    public void addRepository(URL baseURL) throws IOException {
        this.checkNotInit("addRepository");
        LicenseRepository repository = new LicenseRepository();
        repository.setBaseURL(baseURL);
        LOG.debug("Adding a license repository {}", (Object)repository);
        this.addRepository(repository);
    }

    public void addJarRepository() throws IOException {
        this.checkNotInit("addJarRepository");
        URL baseURL = this.getClass().getResource(JAR_LICENSE_REPOSITORY);
        LicenseRepository repository = new LicenseRepository();
        repository.setBaseURL(baseURL);
        LOG.debug("Adding a jar license repository {}", (Object)repository);
        this.addRepository(repository);
    }

    public void addRootPackageClassPathRepository() throws IOException {
        this.checkNotInit("addRootPackageClassPathRepository");
        LOG.debug("Adding a no package class path license repository ");
        this.addRepository(new RootPackageClassPathLicenseRepository());
    }

    @Override
    public Iterator<LicenseRepository> iterator() {
        return this.getRepositories().iterator();
    }

    protected void addRepository(LicenseRepository repository) {
        this.checkNotInit("addRepository");
        if (this.repositories == null) {
            this.repositories = new ArrayList<LicenseRepository>();
        }
        LOG.info("Adding a license repository {}", (Object)repository.getBaseURL());
        this.repositories.add(repository);
    }

    protected void checkInit(String operation) {
        if (!this.init) {
            throw new IllegalStateException("store was not init, operation [" + operation + "] not possible.");
        }
    }

    protected void checkNotInit(String operation) {
        if (this.init) {
            throw new IllegalStateException("store was init, operation [" + operation + "+] not possible.");
        }
    }
}

